/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections.binary;

import java.util.Random;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.WindowKeySerializer;
import org.apache.flink.table.runtime.util.WindowKey;
import org.apache.flink.table.runtime.util.collections.binary.AbstractBytesHashMap;
import org.apache.flink.table.runtime.util.collections.binary.BytesHashMapTestBase;
import org.apache.flink.table.runtime.util.collections.binary.WindowBytesHashMap;
import org.apache.flink.table.types.logical.LogicalType;

public class WindowBytesHashMapTest
extends BytesHashMapTestBase<WindowKey> {
    public WindowBytesHashMapTest() {
        super(new WindowKeySerializer((PagedTypeSerializer)new BinaryRowDataSerializer(KEY_TYPES.length)));
    }

    @Override
    public AbstractBytesHashMap<WindowKey> createBytesHashMap(MemoryManager memoryManager, int memorySize, LogicalType[] keyTypes, LogicalType[] valueTypes) {
        return new WindowBytesHashMap((Object)this, memoryManager, (long)memorySize, (PagedTypeSerializer)new BinaryRowDataSerializer(keyTypes.length), valueTypes.length);
    }

    public WindowKey[] generateRandomKeys(int num) {
        Random rnd = new Random(76518743207143L);
        BinaryRowData[] keys = this.getRandomizedInputs(num, rnd, true);
        WindowKey[] windowKeys = new WindowKey[num];
        for (int i = 0; i < num; ++i) {
            windowKeys[i] = new WindowKey(rnd.nextLong(), (RowData)keys[i]);
        }
        return windowKeys;
    }
}

