/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.StringUtils;

public class RowDataTestUtil {
    public static String rowToString(RowData value, InternalTypeInfo<RowData> rowTypeInfo, TimeZone tz) {
        return RowDataTestUtil.rowToString(value, rowTypeInfo, tz, true);
    }

    public static String rowToString(RowData value, InternalTypeInfo<RowData> rowTypeInfo, TimeZone tz, boolean withHeader) {
        GenericRowData genericRow = RowDataTestUtil.toGenericRowDeeply(value, rowTypeInfo.toRowFieldTypes());
        return RowDataTestUtil.genericRowToString(genericRow, tz, withHeader);
    }

    private static String fieldToString(Object field, TimeZone tz) {
        if (field instanceof Date || field instanceof Time || field instanceof Timestamp) {
            throw new UnsupportedOperationException();
        }
        return StringUtils.arrayAwareToString((Object)field);
    }

    private static String genericRowToString(GenericRowData row, TimeZone tz, boolean withHeader) {
        StringBuilder sb = new StringBuilder();
        if (withHeader) {
            sb.append(row.getRowKind().shortString());
        }
        sb.append("(");
        for (int i = 0; i < row.getArity(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(RowDataTestUtil.fieldToString(row.getField(i), tz));
        }
        sb.append(")");
        return sb.toString();
    }

    public static GenericRowData toGenericRowDeeply(RowData rowData, LogicalType[] types) {
        return RowDataTestUtil.toGenericRowDeeply(rowData, Arrays.asList(types));
    }

    public static GenericRowData toGenericRowDeeply(RowData rowData, List<LogicalType> types) {
        if (rowData instanceof GenericRowData) {
            return (GenericRowData)rowData;
        }
        int fieldNum = rowData.getArity();
        GenericRowData row = new GenericRowData(fieldNum);
        row.setRowKind(rowData.getRowKind());
        for (int i = 0; i < fieldNum; ++i) {
            if (rowData.isNullAt(i)) {
                row.setField(i, null);
                continue;
            }
            LogicalType type = types.get(i);
            RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)type, (int)i);
            Object o = fieldGetter.getFieldOrNull(rowData);
            if (type instanceof RowType) {
                o = RowDataTestUtil.toGenericRowDeeply((RowData)o, type.getChildren());
            }
            row.setField(i, o);
        }
        return row;
    }

    public static void write(BinaryWriter writer, int pos, Object o, LogicalType type) {
        BinaryWriter.write((BinaryWriter)writer, (int)pos, (Object)o, (LogicalType)type, (TypeSerializer)InternalSerializers.create((LogicalType)type));
    }
}

