/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.LazyMemorySegmentPool;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ResettableExternalBufferTest {
    private static final int MEMORY_SIZE = 0x2000000;
    private MemoryManager memManager;
    private IOManager ioManager;
    private Random random;
    private BinaryRowDataSerializer serializer;
    private BinaryRowDataSerializer multiColumnFixedLengthSerializer;
    private BinaryRowDataSerializer multiColumnVariableLengthSerializer;

    ResettableExternalBufferTest() {
    }

    @BeforeEach
    void before() {
        this.memManager = MemoryManagerBuilder.newBuilder().setMemorySize(0x2000000L).build();
        this.ioManager = new IOManagerAsync();
        this.random = new Random();
        this.serializer = new BinaryRowDataSerializer(1);
        this.multiColumnFixedLengthSerializer = new BinaryRowDataSerializer(3);
        this.multiColumnVariableLengthSerializer = new BinaryRowDataSerializer(5);
    }

    private ResettableExternalBuffer newBuffer(long memorySize) {
        return this.newBuffer(memorySize, this.serializer, true);
    }

    private ResettableExternalBuffer newBuffer(long memorySize, BinaryRowDataSerializer serializer, boolean isRowAllInFixedPart) {
        return new ResettableExternalBuffer(this.ioManager, new LazyMemorySegmentPool((Object)this, this.memManager, (int)(memorySize / (long)this.memManager.getPageSize())), (AbstractRowDataSerializer)serializer, isRowAllInFixedPart);
    }

    @Test
    void testLess() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)0).isEqualTo(buffer.getSpillChannels().size());
        this.assertBuffer(expected, buffer);
        buffer.newIterator();
        this.assertBuffer(expected, buffer);
        buffer.close();
    }

    @Test
    void testSpill() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)buffer.getSpillChannels().size()).isGreaterThan(0);
        this.assertBuffer(expected, buffer);
        buffer.newIterator();
        this.assertBuffer(expected, buffer);
        buffer.close();
    }

    @Test
    void testBufferReset() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        this.insertMulti(buffer, 10);
        buffer.reset();
        Assertions.assertThat((int)0).isEqualTo(buffer.size());
        List<Long> expected = this.insertMulti(buffer, 100);
        Assertions.assertThat((int)100).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        buffer.reset();
        expected = this.insertMulti(buffer, 2500);
        Assertions.assertThat((int)2500).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        buffer.close();
    }

    @Test
    void testBufferResetWithSpill() throws Exception {
        int inMemoryThreshold = 20;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        List<Long> expected = this.insertMulti(buffer, 2500);
        Assertions.assertThat((int)2500).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        buffer.reset();
        this.insertMulti(buffer, 2500);
        buffer.newIterator();
        Assertions.assertThat((int)2500).isEqualTo(buffer.size());
        buffer.reset();
        expected = this.insertMulti(buffer, inMemoryThreshold / 2);
        this.assertBuffer(expected, buffer);
        buffer.reset();
        Assertions.assertThat((int)0).isEqualTo(buffer.size());
        expected = this.insertMulti(buffer, 100);
        Assertions.assertThat((int)100).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        buffer.reset();
        buffer.close();
    }

    @Test
    void testHugeRecord() throws Exception {
        try (ResettableExternalBuffer buffer = new ResettableExternalBuffer(this.ioManager, new LazyMemorySegmentPool((Object)this, this.memManager, 98304 / this.memManager.getPageSize()), (AbstractRowDataSerializer)new BinaryRowDataSerializer(1), false);){
            Assertions.assertThatThrownBy(() -> {
                this.writeHuge(buffer, 50000);
                this.writeHuge(buffer, 10);
            }).isInstanceOf(IOException.class);
        }
    }

    @Test
    void testRandomAccessLess() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)0).isEqualTo(buffer.getSpillChannels().size());
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            this.assertRandomAccess(expected, buffer, (int)((Integer)beginPos.get(i)));
        }
        buffer.close();
    }

    @Test
    void testRandomAccessSpill() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)buffer.getSpillChannels().size()).isGreaterThan(0);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            this.assertRandomAccess(expected, buffer, (int)((Integer)beginPos.get(i)));
        }
        buffer.close();
    }

    @Test
    void testBufferResetWithSpillAndRandomAccess() throws Exception {
        List<Long> expected;
        int i;
        int tries = 100;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        for (i = 0; i < 2; ++i) {
            expected = this.insertMulti(buffer, 2500);
            Assertions.assertThat((int)2500).isEqualTo(buffer.size());
            for (int j = 0; j < 100; ++j) {
                this.assertRandomAccess(expected, buffer);
            }
            buffer.reset();
        }
        this.insertMulti(buffer, 2500);
        buffer.newIterator();
        Assertions.assertThat((int)2500).isEqualTo(buffer.size());
        buffer.reset();
        expected = this.insertMulti(buffer, 10);
        for (i = 0; i < 100; ++i) {
            this.assertRandomAccess(expected, buffer);
        }
        buffer.reset();
        Assertions.assertThat((int)0).isEqualTo(buffer.size());
        expected = this.insertMulti(buffer, 100);
        Assertions.assertThat((int)100).isEqualTo(buffer.size());
        for (i = 0; i < 100; ++i) {
            this.assertRandomAccess(expected, buffer);
        }
        buffer.reset();
        buffer.close();
    }

    @Test
    void testMultiColumnFixedLengthRandomAccessLess() throws Exception {
        this.testMultiColumnRandomAccessLess(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test
    void testMultiColumnFixedLengthRandomAccessSpill() throws Exception {
        this.testMultiColumnRandomAccessSpill(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test
    void testBufferResetWithSpillAndMultiColumnFixedLengthRandomAccess() throws Exception {
        this.testBufferResetWithSpillAndMultiColumnRandomAccess(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test
    void testMultiColumnVariableLengthRandomAccessLess() throws Exception {
        this.testMultiColumnRandomAccessLess(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    @Test
    void testMultiColumnVariableLengthRandomAccessSpill() throws Exception {
        this.testMultiColumnRandomAccessSpill(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    @Test
    void testBufferResetWithSpillAndMultiColumnVariableLengthRandomAccess() throws Exception {
        this.testBufferResetWithSpillAndMultiColumnRandomAccess(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    @Test
    void testIteratorOnFixedLengthEmptyBuffer() throws Exception {
        this.testIteratorOnMultiColumnEmptyBuffer(this.multiColumnFixedLengthSerializer, true);
    }

    @Test
    void testFixedLengthRandomAccessOutOfRange() throws Exception {
        this.testRandomAccessOutOfRange(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true);
    }

    @Test
    void testIteratorOnVariableLengthEmptyBuffer() throws Exception {
        this.testIteratorOnMultiColumnEmptyBuffer(this.multiColumnVariableLengthSerializer, false);
    }

    @Test
    void testVariableLengthRandomAccessOutOfRange() throws Exception {
        this.testRandomAccessOutOfRange(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false);
    }

    @Test
    void testIteratorReset() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)0).isEqualTo(buffer.getSpillChannels().size());
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator();
        this.assertBuffer(expected, iterator);
        iterator.reset();
        this.assertBuffer(expected, iterator);
        iterator.close();
        buffer.close();
    }

    @Test
    void testIteratorResetWithSpill() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)buffer.getSpillChannels().size()).isGreaterThan(0);
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator();
        this.assertBuffer(expected, iterator);
        iterator.reset();
        this.assertBuffer(expected, iterator);
        iterator.close();
        buffer.close();
    }

    @Test
    void testIteratorResetWithRandomAccess() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)0).isEqualTo(buffer.getSpillChannels().size());
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            int begin = (Integer)beginPos.get(i);
            ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(begin);
            this.assertRandomAccess(expected, iterator, begin);
            iterator.reset();
            this.assertRandomAccess(expected, iterator, begin);
            iterator.close();
        }
        buffer.close();
    }

    @Test
    void testIteratorResetWithRandomAccessSpill() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)buffer.getSpillChannels().size()).isGreaterThan(0);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            int begin = (Integer)beginPos.get(i);
            ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(begin);
            this.assertRandomAccess(expected, iterator, begin);
            iterator.reset();
            this.assertRandomAccess(expected, iterator, begin);
            iterator.close();
        }
        buffer.close();
    }

    @Test
    void testMultipleIteratorsLess() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 100;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)0).isEqualTo(buffer.getSpillChannels().size());
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            int beginIdx = (Integer)beginPos.get(i);
            ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(beginIdx);
            this.assertRandomAccess(expected, iterator, beginIdx);
            if (i % 3 != 0) continue;
            iterator.close();
        }
        buffer.close();
    }

    @Test
    void testMultipleIteratorsSpill() throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)buffer.getSpillChannels().size()).isGreaterThan(0);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            int beginIdx = (Integer)beginPos.get(i);
            ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(beginIdx);
            this.assertRandomAccess(expected, iterator, beginIdx);
            if (i % 3 != 0) continue;
            iterator.close();
        }
        buffer.close();
    }

    @Test
    void testMultipleIteratorsWithIteratorReset() throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L);
        int number = 5000;
        List<Long> expected = this.insertMulti(buffer, number);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertBuffer(expected, buffer);
        Assertions.assertThat((int)buffer.getSpillChannels().size()).isGreaterThan(0);
        ResettableExternalBuffer.BufferIterator iterator1 = buffer.newIterator();
        this.assertBuffer(expected, iterator1);
        iterator1.reset();
        this.assertBuffer(expected, iterator1);
        ResettableExternalBuffer.BufferIterator iterator2 = buffer.newIterator();
        this.assertBuffer(expected, iterator2);
        iterator2.reset();
        this.assertBuffer(expected, iterator2);
        iterator1.reset();
        this.assertBuffer(expected, iterator1);
        iterator2.reset();
        this.assertBuffer(expected, iterator2);
        iterator1.close();
        iterator2.reset();
        this.assertBuffer(expected, iterator2);
        iterator2.close();
        buffer.close();
    }

    @Test
    void testUpdateIteratorFixedLengthLess() {
        Assertions.assertThatThrownBy(() -> this.testUpdateIteratorLess(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testUpdateIteratorFixedLengthSpill() {
        Assertions.assertThatThrownBy(() -> this.testUpdateIteratorSpill(this.multiColumnFixedLengthSerializer, FixedLengthRowData.class, true)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testUpdateIteratorVariableLengthLess() {
        Assertions.assertThatThrownBy(() -> this.testUpdateIteratorLess(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testUpdateIteratorVariableLengthSpill() {
        Assertions.assertThatThrownBy(() -> this.testUpdateIteratorSpill(this.multiColumnVariableLengthSerializer, VariableLengthRowData.class, false)).isInstanceOf(IllegalStateException.class);
    }

    private <T extends RowData> void testMultiColumnRandomAccessLess(BinaryRowDataSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 30;
        List<RowData> expected = this.insertMultiColumn(buffer, number, clazz);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        Assertions.assertThat((int)0).isEqualTo(buffer.getSpillChannels().size());
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            this.assertMultiColumnRandomAccess(expected, buffer, (Integer)beginPos.get(i));
        }
        buffer.close();
    }

    private <T extends RowData> void testMultiColumnRandomAccessSpill(BinaryRowDataSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 4000;
        List<RowData> expected = this.insertMultiColumn(buffer, number, clazz);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        Assertions.assertThat((int)buffer.getSpillChannels().size()).isGreaterThan(0);
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        for (i = 0; i < buffer.size(); ++i) {
            beginPos.add(i);
        }
        Collections.shuffle(beginPos);
        for (i = 0; i < buffer.size(); ++i) {
            this.assertMultiColumnRandomAccess(expected, buffer, (Integer)beginPos.get(i));
        }
        buffer.close();
    }

    private <T extends RowData> void testBufferResetWithSpillAndMultiColumnRandomAccess(BinaryRowDataSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        List<RowData> expected;
        int i;
        int tries = 100;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        for (i = 0; i < 2; ++i) {
            expected = this.insertMultiColumn(buffer, 1500, clazz);
            Assertions.assertThat((int)1500).isEqualTo(buffer.size());
            for (int j = 0; j < 100; ++j) {
                this.assertMultiColumnRandomAccess(expected, buffer);
            }
            buffer.reset();
        }
        this.insertMultiColumn(buffer, 1500, clazz);
        buffer.newIterator();
        Assertions.assertThat((int)1500).isEqualTo(buffer.size());
        buffer.reset();
        expected = this.insertMultiColumn(buffer, 10, clazz);
        for (i = 0; i < 100; ++i) {
            this.assertMultiColumnRandomAccess(expected, buffer);
        }
        buffer.reset();
        Assertions.assertThat((int)0).isEqualTo(buffer.size());
        expected = this.insertMultiColumn(buffer, 30, clazz);
        Assertions.assertThat((int)30).isEqualTo(buffer.size());
        for (i = 0; i < 100; ++i) {
            this.assertMultiColumnRandomAccess(expected, buffer);
        }
        buffer.reset();
        buffer.close();
    }

    private void testIteratorOnMultiColumnEmptyBuffer(BinaryRowDataSerializer serializer, boolean isRowAllInFixedPart) {
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        buffer.complete();
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(0);
        Assertions.assertThat((boolean)iterator.advanceNext()).isFalse();
        iterator = buffer.newIterator(this.random.nextInt(Integer.MAX_VALUE));
        Assertions.assertThat((boolean)iterator.advanceNext()).isFalse();
        buffer.close();
    }

    private <T extends RowData> void testRandomAccessOutOfRange(BinaryRowDataSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 100;
        List<RowData> expected = this.insertMultiColumn(buffer, number, clazz);
        Assertions.assertThat((int)number).isEqualTo(buffer.size());
        this.assertMultiColumnRandomAccess(expected, buffer, 0);
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(number);
        Assertions.assertThat((boolean)iterator.advanceNext()).isFalse();
        iterator = buffer.newIterator(number + this.random.nextInt(Integer.MAX_VALUE));
        Assertions.assertThat((boolean)iterator.advanceNext()).isFalse();
        iterator = buffer.newIterator(this.random.nextInt(number));
        Assertions.assertThat((boolean)iterator.advanceNext()).isTrue();
        buffer.close();
    }

    private <T extends RowData> void testUpdateIteratorLess(BinaryRowDataSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 20;
        int iters = 3;
        ArrayList<RowData> expected = new ArrayList<RowData>();
        ArrayList<ResettableExternalBuffer.BufferIterator> iterators = new ArrayList<ResettableExternalBuffer.BufferIterator>();
        for (i = 0; i < iters; ++i) {
            iterators.add(buffer.newIterator());
        }
        for (i = 0; i < number; ++i) {
            RowData rowData = (RowData)clazz.newInstance();
            rowData.insertIntoBuffer(buffer);
            expected.add(rowData);
            for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                Assertions.assertThat((boolean)iterator.advanceNext()).isTrue();
                BinaryRowData row = iterator.getRow();
                rowData.checkSame(row);
                Assertions.assertThat((boolean)iterator.advanceNext()).isFalse();
            }
        }
        for (ResettableExternalBuffer.BufferIterator bufferIterator : iterators) {
            bufferIterator.reset();
        }
        for (int i2 = 0; i2 < number; ++i2) {
            for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                Assertions.assertThat((boolean)iterator.advanceNext()).isTrue();
                BinaryRowData row = iterator.getRow();
                ((RowData)expected.get(i2)).checkSame(row);
            }
        }
        for (ResettableExternalBuffer.BufferIterator bufferIterator : iterators) {
            bufferIterator.close();
        }
        this.assertMultiColumnRandomAccess(expected, buffer);
        buffer.close();
    }

    /*
     * WARNING - void declaration
     */
    private <T extends RowData> void testUpdateIteratorSpill(BinaryRowDataSerializer serializer, Class<T> clazz, boolean isRowAllInFixedPart) throws Exception {
        int i;
        ResettableExternalBuffer buffer = this.newBuffer(65536L, serializer, isRowAllInFixedPart);
        int number = 100;
        int step = 20;
        int iters = 3;
        ArrayList<RowData> expected = new ArrayList<RowData>();
        ArrayList<Object> smallExpected = new ArrayList<Object>();
        ArrayList<ResettableExternalBuffer.BufferIterator> iterators = new ArrayList<ResettableExternalBuffer.BufferIterator>();
        for (i = 0; i < iters; ++i) {
            iterators.add(buffer.newIterator());
        }
        for (i = 0; i < number; ++i) {
            void var12_19;
            void var12_17;
            smallExpected.clear();
            boolean bl = false;
            while (var12_17 < step) {
                RowData data = (RowData)clazz.newInstance();
                data.insertIntoBuffer(buffer);
                expected.add(data);
                smallExpected.add(data);
                ++var12_17;
            }
            boolean bl2 = false;
            while (var12_19 < step) {
                for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                    Assertions.assertThat((boolean)iterator.advanceNext()).isTrue();
                    BinaryRowData row = iterator.getRow();
                    ((RowData)smallExpected.get((int)var12_19)).checkSame(row);
                }
                ++var12_19;
            }
            for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                Assertions.assertThat((boolean)iterator.advanceNext()).isFalse();
            }
        }
        for (ResettableExternalBuffer.BufferIterator bufferIterator : iterators) {
            bufferIterator.reset();
        }
        for (int i2 = 0; i2 < number * step; ++i2) {
            for (ResettableExternalBuffer.BufferIterator iterator : iterators) {
                Assertions.assertThat((boolean)iterator.advanceNext()).isTrue();
                BinaryRowData row = iterator.getRow();
                ((RowData)expected.get(i2)).checkSame(row);
            }
        }
        for (ResettableExternalBuffer.BufferIterator bufferIterator : iterators) {
            bufferIterator.close();
        }
        this.assertMultiColumnRandomAccess(expected, buffer);
        buffer.close();
    }

    private void writeHuge(ResettableExternalBuffer buffer, int size) throws IOException {
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        writer.writeString(0, StringData.fromString((String)RandomStringUtils.random((int)size)));
        writer.complete();
        buffer.add((org.apache.flink.table.data.RowData)row);
    }

    private void assertBuffer(List<Long> expected, ResettableExternalBuffer buffer) {
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator();
        this.assertBuffer(expected, iterator);
        iterator.close();
    }

    private void assertBuffer(List<Long> expected, ResettableExternalBuffer.BufferIterator iterator) {
        ArrayList<Long> values = new ArrayList<Long>();
        while (iterator.advanceNext()) {
            values.add(iterator.getRow().getLong(0));
        }
        Assertions.assertThat(values).isEqualTo(expected);
    }

    private List<Long> insertMulti(ResettableExternalBuffer buffer, int cnt) throws IOException {
        ArrayList<Long> expected = new ArrayList<Long>(cnt);
        this.insertMulti(buffer, cnt, expected);
        buffer.complete();
        return expected;
    }

    private void insertMulti(ResettableExternalBuffer buffer, int cnt, List<Long> expected) throws IOException {
        for (int i = 0; i < cnt; ++i) {
            expected.add(this.randomInsert(buffer));
        }
    }

    private long randomInsert(ResettableExternalBuffer buffer) throws IOException {
        long l = this.random.nextLong();
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        writer.writeLong(0, l);
        writer.complete();
        buffer.add((org.apache.flink.table.data.RowData)row);
        return l;
    }

    private void assertRandomAccess(List<Long> expected, ResettableExternalBuffer buffer) {
        int begin = this.random.nextInt(buffer.size());
        this.assertRandomAccess(expected, buffer, begin);
    }

    private void assertRandomAccess(List<Long> expected, ResettableExternalBuffer buffer, int begin) {
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(begin);
        this.assertRandomAccess(expected, iterator, begin);
        iterator.close();
    }

    private void assertRandomAccess(List<Long> expected, ResettableExternalBuffer.BufferIterator iterator, int begin) {
        ArrayList<Long> values = new ArrayList<Long>();
        while (iterator.advanceNext()) {
            values.add(iterator.getRow().getLong(0));
        }
        Assertions.assertThat(values).isEqualTo(expected.subList(begin, expected.size()));
    }

    private <T extends RowData> List<RowData> insertMultiColumn(ResettableExternalBuffer buffer, int cnt, Class<T> clazz) throws IOException, IllegalAccessException, InstantiationException {
        ArrayList<RowData> expected = new ArrayList<RowData>(cnt);
        this.insertMultiColumn(buffer, cnt, expected, clazz);
        buffer.complete();
        return expected;
    }

    private <T extends RowData> void insertMultiColumn(ResettableExternalBuffer buffer, int cnt, List<RowData> expected, Class<T> clazz) throws IOException, IllegalAccessException, InstantiationException {
        for (int i = 0; i < cnt; ++i) {
            RowData data = (RowData)clazz.newInstance();
            data.insertIntoBuffer(buffer);
            expected.add(data);
        }
        buffer.complete();
    }

    private void assertMultiColumnRandomAccess(List<RowData> expected, ResettableExternalBuffer buffer) {
        int begin = this.random.nextInt(buffer.size());
        this.assertMultiColumnRandomAccess(expected, buffer, begin);
    }

    private void assertMultiColumnRandomAccess(List<RowData> expected, ResettableExternalBuffer buffer, int begin) {
        ResettableExternalBuffer.BufferIterator iterator = buffer.newIterator(begin);
        for (int i = begin; i < buffer.size(); ++i) {
            Assertions.assertThat((boolean)iterator.advanceNext()).isTrue();
            expected.get(i).checkSame(iterator.getRow());
        }
    }

    private static class VariableLengthRowData
    implements RowData {
        private final boolean col0;
        private final long col1;
        private final StringData col2;
        private final int col3;
        private final StringData col4;

        public VariableLengthRowData() {
            Random random = new Random();
            this.col0 = random.nextBoolean();
            this.col1 = random.nextLong();
            this.col2 = StringData.fromString((String)RandomStringUtils.random((int)(random.nextInt(50) + 1)));
            this.col3 = random.nextInt();
            this.col4 = StringData.fromString((String)RandomStringUtils.random((int)(random.nextInt(50) + 1)));
        }

        @Override
        public void insertIntoBuffer(ResettableExternalBuffer buffer) throws IOException {
            BinaryRowData row = new BinaryRowData(5);
            BinaryRowWriter writer = new BinaryRowWriter(row);
            writer.reset();
            writer.writeBoolean(0, this.col0);
            writer.writeLong(1, this.col1);
            writer.writeString(2, this.col2);
            writer.writeInt(3, this.col3);
            writer.writeString(4, this.col4);
            writer.complete();
            buffer.add((org.apache.flink.table.data.RowData)row);
        }

        @Override
        public void checkSame(BinaryRowData row) {
            Assertions.assertThat((boolean)row.getBoolean(0)).isEqualTo(this.col0);
            Assertions.assertThat((long)row.getLong(1)).isEqualTo(this.col1);
            Assertions.assertThat((Comparable)row.getString(2)).isEqualTo((Object)this.col2);
            Assertions.assertThat((int)row.getInt(3)).isEqualTo(this.col3);
            Assertions.assertThat((Comparable)row.getString(4)).isEqualTo((Object)this.col4);
        }
    }

    private static class FixedLengthRowData
    implements RowData {
        private final boolean col0;
        private final long col1;
        private final int col2;

        FixedLengthRowData() {
            Random random = new Random();
            this.col0 = random.nextBoolean();
            this.col1 = random.nextLong();
            this.col2 = random.nextInt();
        }

        @Override
        public void insertIntoBuffer(ResettableExternalBuffer buffer) throws IOException {
            BinaryRowData row = new BinaryRowData(3);
            BinaryRowWriter writer = new BinaryRowWriter(row);
            writer.reset();
            writer.writeBoolean(0, this.col0);
            writer.writeLong(1, this.col1);
            writer.writeInt(2, this.col2);
            writer.complete();
            buffer.add((org.apache.flink.table.data.RowData)row);
        }

        @Override
        public void checkSame(BinaryRowData row) {
            Assertions.assertThat((boolean)row.getBoolean(0)).isEqualTo(this.col0);
            Assertions.assertThat((long)row.getLong(1)).isEqualTo(this.col1);
            Assertions.assertThat((int)row.getInt(2)).isEqualTo(this.col2);
        }
    }

    private static interface RowData {
        public void insertIntoBuffer(ResettableExternalBuffer var1) throws IOException;

        public void checkSame(BinaryRowData var1);
    }
}

