/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.table.runtime.typeutils.LinkedListSerializer;
import org.apache.flink.test.util.MigrationTest;
import org.assertj.core.api.Condition;

@VisibleForTesting
public class LinkedListSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<LinkedList<Long>, LinkedList<Long>> {
    public Collection<FlinkVersion> getMigrationVersions() {
        return FlinkVersion.rangeOf((FlinkVersion)FlinkVersion.v1_13, (FlinkVersion)MigrationTest.getMostRecentlyPublishedVersion());
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        return Collections.singletonList(new TypeSerializerUpgradeTestBase.TestSpecification("linked-list-serializer", flinkVersion, LinkedListSerializerSetup.class, LinkedListSerializerVerifier.class));
    }

    public static TypeSerializer<LinkedList<Long>> createLinkedListSerializer() {
        return new LinkedListSerializer((TypeSerializer)new LongSerializer());
    }

    public static final class LinkedListSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<LinkedList<Long>> {
        public TypeSerializer<LinkedList<Long>> createUpgradedSerializer() {
            return LinkedListSerializerUpgradeTest.createLinkedListSerializer();
        }

        public Condition<LinkedList<Long>> testDataCondition() {
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(42L);
            list.add(-42L);
            list.add(0L);
            list.add(Long.MAX_VALUE);
            list.add(Long.MIN_VALUE);
            return new Condition(list::equals, "", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<LinkedList<Long>>> schemaCompatibilityCondition(FlinkVersion version) {
            if (version.isNewerVersionThan(FlinkVersion.v1_13)) {
                return TypeSerializerConditions.isCompatibleAsIs();
            }
            return TypeSerializerConditions.isCompatibleAfterMigration();
        }
    }

    public static final class LinkedListSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<LinkedList<Long>> {
        public TypeSerializer<LinkedList<Long>> createPriorSerializer() {
            return LinkedListSerializerUpgradeTest.createLinkedListSerializer();
        }

        public LinkedList<Long> createTestData() {
            LinkedList<Long> list = new LinkedList<Long>();
            list.add(42L);
            list.add(-42L);
            list.add(0L);
            list.add(Long.MAX_VALUE);
            list.add(Long.MIN_VALUE);
            return list;
        }
    }
}

