/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate.linked;

import java.util.Objects;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.HashFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowDataKey;
import org.apache.flink.table.runtime.sequencedmultisetstate.linked.RowDataKeySerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;

public class RowDataKeySerializerTest
extends SerializerTestBase<RowDataKey> {
    private final TestRecordEqualiser equaliser = new TestRecordEqualiser();
    static final GeneratedRecordEqualiser EQUALISER = new GeneratedRecordEqualiser("", "", new Object[0]){

        public RecordEqualiser newInstance(ClassLoader classLoader) {
            return new TestRecordEqualiser();
        }
    };
    static final GeneratedHashFunction HASH_FUNCTION = new GeneratedHashFunction("", "", new Object[0], (ReadableConfig)new Configuration()){

        public HashFunction newInstance(ClassLoader classLoader) {
            return new TestRecordEqualiser();
        }
    };

    protected TypeSerializer<RowDataKey> createSerializer() {
        return new RowDataKeySerializer((TypeSerializer)new RowDataSerializer(new LogicalType[]{new IntType()}), (RecordEqualiser)this.equaliser, (HashFunction)this.equaliser, EQUALISER, HASH_FUNCTION);
    }

    protected int getLength() {
        return -1;
    }

    protected Class<RowDataKey> getTypeClass() {
        return RowDataKey.class;
    }

    protected RowDataKey[] getTestData() {
        return new RowDataKey[]{new RowDataKey(StreamRecordUtils.row(123), (RecordEqualiser)this.equaliser, (HashFunction)this.equaliser)};
    }

    private static class TestRecordEqualiser
    implements RecordEqualiser,
    HashFunction {
        private TestRecordEqualiser() {
        }

        public boolean equals(RowData row1, RowData row2) {
            return row1.getRowKind() == row2.getRowKind() && row1.getInt(0) == row2.getInt(0);
        }

        public int hashCode(Object data) {
            RowData rd = (RowData)data;
            return Objects.hash(rd.getRowKind(), rd.getInt(0));
        }

        public boolean equals(Object obj) {
            return obj instanceof TestRecordEqualiser;
        }

        public int hashCode() {
            return 0;
        }
    }
}

