/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.groupwindow.assigners;

import java.time.Duration;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.TumblingWindowAssigner;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TumblingWindowAssignerTest {
    private static final RowData ELEMENT = GenericRowData.of((Object[])new Object[]{"String"});

    TumblingWindowAssignerTest() {
    }

    @Test
    void testWindowAssignment() {
        TumblingWindowAssigner assigner = TumblingWindowAssigner.of((Duration)Duration.ofMillis(5000L));
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 0L)).contains((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 4999L)).contains((Object[])new TimeWindow[]{new TimeWindow(0L, 5000L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 5000L)).contains((Object[])new TimeWindow[]{new TimeWindow(5000L, 10000L)});
    }

    @Test
    void testWindowAssignmentWithOffset() {
        TumblingWindowAssigner assigner = TumblingWindowAssigner.of((Duration)Duration.ofMillis(5000L)).withOffset(Duration.ofMillis(100L));
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 100L)).contains((Object[])new TimeWindow[]{new TimeWindow(100L, 5100L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 5099L)).contains((Object[])new TimeWindow[]{new TimeWindow(100L, 5100L)});
        Assertions.assertThat((Collection)assigner.assignWindows(ELEMENT, 5100L)).contains((Object[])new TimeWindow[]{new TimeWindow(5100L, 10100L)});
    }

    @Test
    void testInvalidParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TumblingWindowAssigner.of((Duration)Duration.ofSeconds(-1L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("TumblingWindowAssigner parameters must satisfy size > 0");
        TumblingWindowAssigner.of((Duration)Duration.ofSeconds(10L)).withOffset(Duration.ofSeconds(20L));
        TumblingWindowAssigner.of((Duration)Duration.ofSeconds(10L)).withOffset(Duration.ofSeconds(-1L));
    }

    @Test
    void testProperties() {
        TumblingWindowAssigner assigner = TumblingWindowAssigner.of((Duration)Duration.ofMillis(5000L));
        Assertions.assertThat((boolean)assigner.isEventTime()).isTrue();
        Assertions.assertThat((Object)assigner.getWindowSerializer(new ExecutionConfig())).isEqualTo((Object)new TimeWindow.Serializer());
        Assertions.assertThat((boolean)assigner.withEventTime().isEventTime()).isTrue();
        Assertions.assertThat((boolean)assigner.withProcessingTime().isEventTime()).isFalse();
    }
}

