/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.sort.BinaryMergeIterator;
import org.apache.flink.table.runtime.operators.sort.IntRecordComparator;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BinaryMergeIteratorTest {
    private RecordComparator comparator;
    private BinaryRowDataSerializer serializer;

    BinaryMergeIteratorTest() {
    }

    @BeforeEach
    void setup() throws InstantiationException, IllegalAccessException {
        this.serializer = new BinaryRowDataSerializer(2);
        this.comparator = IntRecordComparator.INSTANCE;
    }

    private MutableObjectIterator<BinaryRowData> newIterator(final int[] keys, final String[] values) {
        final BinaryRowData row = this.serializer.createInstance();
        final BinaryRowWriter writer = new BinaryRowWriter(row);
        return new MutableObjectIterator<BinaryRowData>(){
            private int current = 0;

            public BinaryRowData next(BinaryRowData reuse) {
                if (this.current < keys.length) {
                    int key = keys[this.current];
                    String value = values[this.current];
                    ++this.current;
                    writer.reset();
                    writer.writeInt(0, key);
                    writer.writeString(1, StringData.fromString((String)value));
                    writer.complete();
                    return row;
                }
                return null;
            }

            public BinaryRowData next() {
                throw new RuntimeException();
            }
        };
    }

    @Test
    void testOneStream() throws Exception {
        ArrayList<MutableObjectIterator<BinaryRowData>> iterators = new ArrayList<MutableObjectIterator<BinaryRowData>>();
        iterators.add(this.newIterator(new int[]{1, 2, 4, 5, 10}, new String[]{"1", "2", "4", "5", "10"}));
        int[] expected = new int[]{1, 2, 4, 5, 10};
        BinaryMergeIterator iterator = new BinaryMergeIterator(iterators, Collections.singletonList(this.serializer.createInstance()), (o1, o2) -> this.comparator.compare((RowData)o1, (RowData)o2));
        BinaryRowData row = this.serializer.createInstance();
        int pos = 0;
        while ((row = (BinaryRowData)iterator.next((Object)row)) != null) {
            Assertions.assertThat((int)row.getInt(0)).isEqualTo(expected[pos++]);
        }
    }

    @Test
    void testMergeOfTwoStreams() throws Exception {
        ArrayList<MutableObjectIterator<BinaryRowData>> iterators = new ArrayList<MutableObjectIterator<BinaryRowData>>();
        iterators.add(this.newIterator(new int[]{1, 2, 4, 5, 10}, new String[]{"1", "2", "4", "5", "10"}));
        iterators.add(this.newIterator(new int[]{3, 6, 7, 10, 12}, new String[]{"3", "6", "7", "10", "12"}));
        int[] expected = new int[]{1, 2, 3, 4, 5, 6, 7, 10, 10, 12};
        BinaryMergeIterator iterator = new BinaryMergeIterator(iterators, this.reused(2), (o1, o2) -> this.comparator.compare((RowData)o1, (RowData)o2));
        BinaryRowData row = this.serializer.createInstance();
        int pos = 0;
        while ((row = (BinaryRowData)iterator.next((Object)row)) != null) {
            Assertions.assertThat((int)row.getInt(0)).isEqualTo(expected[pos++]);
        }
    }

    @Test
    void testMergeOfTenStreams() throws Exception {
        ArrayList<MutableObjectIterator<BinaryRowData>> iterators = new ArrayList<MutableObjectIterator<BinaryRowData>>();
        iterators.add(this.newIterator(new int[]{1, 2, 17, 23, 23}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{2, 6, 7, 8, 9}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{4, 10, 11, 11, 12}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{3, 6, 7, 10, 12}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{7, 10, 15, 19, 44}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{6, 6, 11, 17, 18}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{1, 2, 4, 5, 10}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{5, 10, 19, 23, 29}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{9, 9, 9, 9, 9}, new String[]{"A", "B", "C", "D", "E"}));
        iterators.add(this.newIterator(new int[]{8, 8, 14, 14, 15}, new String[]{"A", "B", "C", "D", "E"}));
        IntComparator comparator = new IntComparator(true);
        BinaryMergeIterator iterator = new BinaryMergeIterator(iterators, this.reused(10), (o1, o2) -> this.comparator.compare((RowData)o1, (RowData)o2));
        BinaryRowData row = this.serializer.createInstance();
        int pre = 0;
        while ((row = (BinaryRowData)iterator.next((Object)row)) != null) {
            Assertions.assertThat((int)comparator.compare((Object)row.getInt(0), (Object)pre)).isGreaterThanOrEqualTo(0);
            pre = row.getInt(0);
        }
    }

    private List<BinaryRowData> reused(int size) {
        ArrayList<BinaryRowData> ret = new ArrayList<BinaryRowData>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(this.serializer.createInstance());
        }
        return ret;
    }
}

