/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.over.AbstractNonTimeUnboundedPrecedingOver;
import org.apache.flink.table.runtime.operators.over.RowTimeOverWindowTestBase;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.HandwrittenSelectorUtil;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Assertions;

public abstract class NonTimeOverWindowTestBase
extends RowTimeOverWindowTestBase {
    private static final int SORT_KEY_IDX = 1;
    static final LogicalType[] SORT_KEY_TYPES = new LogicalType[]{new BigIntType()};
    private static final InternalTypeInfo<RowData> INPUT_ROW_TYPE = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{VarCharType.STRING_TYPE, new BigIntType(), new BigIntType()});
    static final RowDataKeySelector SORT_KEY_SELECTOR = HandwrittenSelectorUtil.getRowDataSelector(new int[]{1}, INPUT_ROW_TYPE.toRowFieldTypes());
    static final GeneratedRecordComparator GENERATED_SORT_KEY_COMPARATOR_ASC = new GeneratedRecordComparator("", "", new Object[0]){
        private static final long serialVersionUID = 1L;

        public RecordComparator newInstance(ClassLoader classLoader) {
            return new LongRecordComparator(0, true);
        }
    };
    static final GeneratedRecordComparator GENERATED_SORT_KEY_COMPARATOR_DESC = new GeneratedRecordComparator("", "", new Object[0]){
        private static final long serialVersionUID = 1L;

        public RecordComparator newInstance(ClassLoader classLoader) {
            return new LongRecordComparator(0, false);
        }
    };
    static final GeneratedRecordEqualiser GENERATED_ROW_VALUE_EQUALISER = new GeneratedRecordEqualiser("", "", new Object[0]){
        private static final long serialVersionUID = 1L;

        public RecordEqualiser newInstance(ClassLoader classLoader) {
            return new TestRowValueEqualiser();
        }
    };
    static final GeneratedRecordEqualiser GENERATED_SORT_KEY_EQUALISER = new GeneratedRecordEqualiser("", "", new Object[0]){
        private static final long serialVersionUID = 1L;

        public RecordEqualiser newInstance(ClassLoader classLoader) {
            return new TestSortKeyEqualiser();
        }
    };

    abstract void validateEntry(AbstractNonTimeUnboundedPrecedingOver<RowData> var1, RowData var2, int var3) throws Exception;

    abstract void validateNumAccRows(int var1, int var2, int var3);

    void validateState(AbstractNonTimeUnboundedPrecedingOver<RowData> function, RowData record, int listPos, int expectedSortedListSize, int idPos, int expectedNumOfIds, int idOffset, int totalRows, boolean isInsertion) throws Exception {
        List sortedList = (List)function.getRuntimeContext().getState(function.sortedListStateDescriptor).value();
        Assertions.assertThat((int)sortedList.size()).isEqualTo(expectedSortedListSize);
        if (isInsertion) {
            Assertions.assertThat((int)((List)((Tuple2)sortedList.get((int)listPos)).f1).size()).isEqualTo(expectedNumOfIds);
            Assertions.assertThat((Long)((Long)((List)((Tuple2)sortedList.get((int)listPos)).f1).get(idPos))).isEqualTo(Long.MIN_VALUE + (long)idOffset);
        } else if (listPos < sortedList.size()) {
            Tuple2 rowDataListTuple = (Tuple2)sortedList.get(listPos);
            if (rowDataListTuple != null) {
                Assertions.assertThat((List)((List)rowDataListTuple.f1)).doesNotContain((Object[])new Long[]{Long.MIN_VALUE + (long)idOffset});
            }
        } else {
            Assertions.assertThat((Object)((RowData)function.getRuntimeContext().getMapState(function.accStateDescriptor).get((Object)((RowData)SORT_KEY_SELECTOR.getKey((Object)record))))).isNull();
        }
        AtomicInteger numRows = new AtomicInteger();
        function.getRuntimeContext().getMapState(function.valueStateDescriptor).keys().forEach(row -> numRows.getAndIncrement());
        Assertions.assertThat((int)numRows.get()).isEqualTo(totalRows);
        if (isInsertion) {
            Assertions.assertThat((String)((RowData)function.getRuntimeContext().getMapState(function.valueStateDescriptor).get((Object)(Long.MIN_VALUE + (long)idOffset))).toString()).isEqualTo(record.toString());
        } else {
            Assertions.assertThat((Object)((RowData)function.getRuntimeContext().getMapState(function.valueStateDescriptor).get((Object)(Long.MIN_VALUE + (long)idOffset)))).isNull();
        }
        AtomicInteger numAccRows = new AtomicInteger();
        function.getRuntimeContext().getMapState(function.accStateDescriptor).keys().forEach(row -> numAccRows.getAndIncrement());
        this.validateNumAccRows(numAccRows.get(), expectedSortedListSize, totalRows);
        if (isInsertion) {
            this.validateEntry(function, record, idOffset);
        }
    }

    void validateRows(List<RowData> actualRows, List<RowData> expectedRows) {
        Assertions.assertThat((int)actualRows.size()).isEqualTo(expectedRows.size());
        for (int i = 0; i < actualRows.size(); ++i) {
            Assertions.assertThat((Comparable)actualRows.get(i).getRowKind()).isEqualTo((Object)expectedRows.get(i).getRowKind());
            Assertions.assertThat((Comparable)actualRows.get(i).getString(0)).isEqualTo((Object)expectedRows.get(i).getString(0));
            Assertions.assertThat((long)actualRows.get(i).getLong(1)).isEqualTo(expectedRows.get(i).getLong(1));
            Assertions.assertThat((long)actualRows.get(i).getLong(2)).isEqualTo(expectedRows.get(i).getLong(2));
            Assertions.assertThat((long)actualRows.get(i).getLong(3)).isEqualTo(expectedRows.get(i).getLong(3));
        }
    }

    JoinedRowData outputRecord(RowKind rowKind, String key, Long val, Long ts, Long aggVal) {
        return new JoinedRowData(rowKind, (RowData)GenericRowData.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{StringData.fromString((String)key), val, ts}), (RowData)GenericRowData.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{aggVal}));
    }

    public static class TestSortKeyEqualiser
    implements RecordEqualiser {
        private static final long serialVersionUID = -6706336100425614942L;

        public boolean equals(RowData row1, RowData row2) {
            if (row1 instanceof BinaryRowData && row2 instanceof BinaryRowData) {
                return row1.equals(row2);
            }
            if (row1 instanceof GenericRowData && row2 instanceof GenericRowData) {
                return row1.getLong(0) == row2.getLong(0);
            }
            throw new UnsupportedOperationException();
        }
    }

    public static class TestRowValueEqualiser
    implements RecordEqualiser {
        private static final long serialVersionUID = -6706336100425614942L;

        public boolean equals(RowData row1, RowData row2) {
            if (row1 instanceof BinaryRowData && row2 instanceof BinaryRowData) {
                return row1.equals(row2);
            }
            if (row1 instanceof GenericRowData && row2 instanceof GenericRowData) {
                return row1.getString(0).equals(row2.getString(0)) && row1.getLong(1) == row2.getLong(1) && row1.getLong(2) == row2.getLong(2);
            }
            throw new UnsupportedOperationException();
        }
    }

    public static class LongRecordComparator
    implements RecordComparator {
        private int pos;
        private boolean isAscending;

        public LongRecordComparator(int pos, boolean isAscending) {
            this.pos = pos;
            this.isAscending = isAscending;
        }

        public int compare(RowData o1, RowData o2) {
            int cmp0;
            boolean null0At1 = o1.isNullAt(this.pos);
            boolean null0At2 = o2.isNullAt(this.pos);
            int n = null0At1 && null0At2 ? 0 : (null0At1 ? -1 : (cmp0 = null0At2 ? 1 : Long.compare(o1.getLong(this.pos), o2.getLong(this.pos))));
            if (cmp0 != 0) {
                if (this.isAscending) {
                    return cmp0;
                }
                return -cmp0;
            }
            return 0;
        }
    }
}

