/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.multijoin;

import java.util.List;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.multijoin.StreamingMultiJoinOperatorTestBase;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.util.StateParameterizedHarnessTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamingTwoWayJoinNoUniqueKeyOperatorTest
extends StreamingMultiJoinOperatorTestBase {
    public StreamingTwoWayJoinNoUniqueKeyOperatorTest(StateParameterizedHarnessTestBase.StateBackendMode stateBackendMode) {
        super(stateBackendMode, 2, List.of(FlinkJoinType.INNER, FlinkJoinType.INNER), StreamingTwoWayJoinNoUniqueKeyOperatorTest.defaultConditions(), false);
        this.inputSpecs.set(0, JoinInputSideSpec.withoutUniqueKey());
        this.inputSpecs.set(1, JoinInputSideSpec.withoutUniqueKey());
    }

    @TestTemplate
    void testInnerJoinWithNoUniqueKeyOnRight() throws Exception {
        this.insertUser("1", "Gus", "User 1 Details");
        this.emitsNothing();
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details");
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details");
        this.insertOrder("1", "order_2", "Order 2 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", "1", "order_2", "Order 2 Details");
        this.insertUser("2", "Bob", "User 2 Details");
        this.emitsNothing();
        this.insertOrder("2", "order_3", "Order 3 Details");
        this.emits(INSERT, "2", "Bob", "User 2 Details", "2", "order_3", "Order 3 Details");
        this.deleteUser("1", "Gus", "User 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details"), DELETE, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details"), DELETE, this.r("1", "Gus", "User 1 Details", "1", "order_2", "Order 2 Details"));
        this.insertUser("1", "Gus Updated", "User 1 Details");
        this.emits(INSERT, this.r("1", "Gus Updated", "User 1 Details", "1", "order_1", "Order 1 Details"), INSERT, this.r("1", "Gus Updated", "User 1 Details", "1", "order_1", "Order 1 Details"), INSERT, this.r("1", "Gus Updated", "User 1 Details", "1", "order_2", "Order 2 Details"));
        this.deleteOrder("1", "order_1", "Order 1 Details");
        this.emits(DELETE, "1", "Gus Updated", "User 1 Details", "1", "order_1", "Order 1 Details");
        this.updateAfterOrder("1", "order_1", "Order 1 Details - Second instance");
        this.emits(UPDATE_AFTER, "1", "Gus Updated", "User 1 Details", "1", "order_1", "Order 1 Details - Second instance");
        this.deleteOrder("1", "order_2", "Order 2 Details");
        this.emits(DELETE, "1", "Gus Updated", "User 1 Details", "1", "order_2", "Order 2 Details");
        this.deleteUser("1", "Gus Updated", "User 1 Details");
        this.emits(DELETE, this.r("1", "Gus Updated", "User 1 Details", "1", "order_1", "Order 1 Details"), DELETE, this.r("1", "Gus Updated", "User 1 Details", "1", "order_1", "Order 1 Details - Second instance"));
    }
}

