/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.multijoin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.multijoin.StreamingMultiJoinOperatorTestBase;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.util.StateParameterizedHarnessTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamingFourWayMixedInnerJoinOperatorTest
extends StreamingMultiJoinOperatorTestBase {
    private static final List<GeneratedJoinCondition> customJoinConditions = Arrays.asList(null, StreamingFourWayMixedInnerJoinOperatorTest.createJoinCondition(1, 0), StreamingFourWayMixedInnerJoinOperatorTest.createJoinCondition(2, 0), StreamingFourWayMixedInnerJoinOperatorTest.createJoinCondition(3, 0));
    private static final Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> customAttributeMap = new HashMap<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>>();

    public StreamingFourWayMixedInnerJoinOperatorTest(StateParameterizedHarnessTestBase.StateBackendMode stateBackendMode) {
        super(stateBackendMode, 4, List.of(FlinkJoinType.INNER, FlinkJoinType.INNER, FlinkJoinType.INNER, FlinkJoinType.INNER), customJoinConditions, customAttributeMap, false);
        this.inputSpecs.set(3, JoinInputSideSpec.withoutUniqueKey());
    }

    @TestTemplate
    void testFourWayMixedInnerJoin() throws Exception {
        this.insertUser("uid1", "u1", "User 1");
        this.emitsNothing();
        this.insertOrder("uid1", "o1", "Order 1");
        this.emitsNothing();
        this.insertPayment("uid1", "pay1", "Payment 1");
        this.emitsNothing();
        this.insertShipment("uid1", "s1", "Shipment 1");
        this.emits(INSERT, "uid1", "u1", "User 1", "uid1", "o1", "Order 1", "uid1", "pay1", "Payment 1", "uid1", "s1", "Shipment 1");
        this.insertUser("uid2", "u2", "User 2");
        this.insertOrder("uid2", "o2", "Order 2");
        this.insertPayment("uid2", "pay2", "Payment 2");
        this.emitsNothing();
        this.insertShipment("uid2", "s2", "Shipment 2");
        this.emits(INSERT, "uid2", "u2", "User 2", "uid2", "o2", "Order 2", "uid2", "pay2", "Payment 2", "uid2", "s2", "Shipment 2");
        this.insertOrder("uid1", "o1_extra", "Order 1 Extra");
        this.emits(INSERT, "uid1", "u1", "User 1", "uid1", "o1_extra", "Order 1 Extra", "uid1", "pay1", "Payment 1", "uid1", "s1", "Shipment 1");
        this.insertShipment("uid1", "s1_another", "Shipment 1 Another");
        this.emits(INSERT, this.r("uid1", "u1", "User 1", "uid1", "o1", "Order 1", "uid1", "pay1", "Payment 1", "uid1", "s1_another", "Shipment 1 Another"), INSERT, this.r("uid1", "u1", "User 1", "uid1", "o1_extra", "Order 1 Extra", "uid1", "pay1", "Payment 1", "uid1", "s1_another", "Shipment 1 Another"));
    }

    @TestTemplate
    void testFourWayMixedInnerJoinUpdating() throws Exception {
        this.insertUser("uid1", "u1", "User 1");
        this.insertOrder("uid1", "o1", "Order 1");
        this.insertPayment("uid1", "pay1", "Payment 1");
        this.insertShipment("uid1", "s1", "Shipment 1");
        this.emits(INSERT, "uid1", "u1", "User 1", "uid1", "o1", "Order 1", "uid1", "pay1", "Payment 1", "uid1", "s1", "Shipment 1");
        this.deleteUser("uid1", "u1", "User 1");
        this.emits(DELETE, "uid1", "u1", "User 1", "uid1", "o1", "Order 1", "uid1", "pay1", "Payment 1", "uid1", "s1", "Shipment 1");
        this.insertUser("uid1", "u1_new", "User 1 New");
        this.emits(INSERT, "uid1", "u1_new", "User 1 New", "uid1", "o1", "Order 1", "uid1", "pay1", "Payment 1", "uid1", "s1", "Shipment 1");
        this.deleteOrder("uid1", "o1", "Order 1");
        this.emits(DELETE, "uid1", "u1_new", "User 1 New", "uid1", "o1", "Order 1", "uid1", "pay1", "Payment 1", "uid1", "s1", "Shipment 1");
        this.insertOrder("uid1", "o1_new", "Order 1 New");
        this.emits(INSERT, "uid1", "u1_new", "User 1 New", "uid1", "o1_new", "Order 1 New", "uid1", "pay1", "Payment 1", "uid1", "s1", "Shipment 1");
        this.deletePayment("uid1", "pay1", "Payment 1");
        this.emits(DELETE, "uid1", "u1_new", "User 1 New", "uid1", "o1_new", "Order 1 New", "uid1", "pay1", "Payment 1", "uid1", "s1", "Shipment 1");
        this.insertPayment("uid1", "pay1_new", "Payment 1 New");
        this.emits(INSERT, "uid1", "u1_new", "User 1 New", "uid1", "o1_new", "Order 1 New", "uid1", "pay1_new", "Payment 1 New", "uid1", "s1", "Shipment 1");
        this.deleteShipment("uid1", "s1", "Shipment 1");
        this.emits(DELETE, "uid1", "u1_new", "User 1 New", "uid1", "o1_new", "Order 1 New", "uid1", "pay1_new", "Payment 1 New", "uid1", "s1", "Shipment 1");
        this.insertShipment("uid1", "s1_new", "Shipment 1 New");
        this.emits(INSERT, "uid1", "u1_new", "User 1 New", "uid1", "o1_new", "Order 1 New", "uid1", "pay1_new", "Payment 1 New", "uid1", "s1_new", "Shipment 1 New");
        this.updateBeforeUser("uid1", "u1_new", "User 1 New");
        this.emits(UPDATE_BEFORE, "uid1", "u1_new", "User 1 New", "uid1", "o1_new", "Order 1 New", "uid1", "pay1_new", "Payment 1 New", "uid1", "s1_new", "Shipment 1 New");
        this.updateAfterUser("uid1", "u1_updated", "User 1 Updated");
        this.emits(UPDATE_AFTER, "uid1", "u1_updated", "User 1 Updated", "uid1", "o1_new", "Order 1 New", "uid1", "pay1_new", "Payment 1 New", "uid1", "s1_new", "Shipment 1 New");
        this.updateBeforeOrder("uid1", "o1_new", "Order 1 New");
        this.emits(UPDATE_BEFORE, "uid1", "u1_updated", "User 1 Updated", "uid1", "o1_new", "Order 1 New", "uid1", "pay1_new", "Payment 1 New", "uid1", "s1_new", "Shipment 1 New");
        this.updateAfterOrder("uid1", "o1_updated", "Order 1 Updated");
        this.emits(UPDATE_AFTER, "uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_new", "Payment 1 New", "uid1", "s1_new", "Shipment 1 New");
        this.updateBeforePayment("uid1", "pay1_new", "Payment 1 New");
        this.emits(UPDATE_BEFORE, "uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_new", "Payment 1 New", "uid1", "s1_new", "Shipment 1 New");
        this.updateAfterPayment("uid1", "pay1_updated", "Payment 1 Updated");
        this.emits(UPDATE_AFTER, "uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_updated", "Payment 1 Updated", "uid1", "s1_new", "Shipment 1 New");
        this.deleteShipment("uid1", "s1_new", "Shipment 1 New");
        this.emits(DELETE, "uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_updated", "Payment 1 Updated", "uid1", "s1_new", "Shipment 1 New");
        this.insertShipment("uid1", "s1_updated", "Shipment 1 Updated");
        this.emits(INSERT, "uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_updated", "Payment 1 Updated", "uid1", "s1_updated", "Shipment 1 Updated");
        this.insertShipment("uid1", "s2_another", "Shipment 2 Another");
        this.emits(INSERT, "uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_updated", "Payment 1 Updated", "uid1", "s2_another", "Shipment 2 Another");
        this.deletePayment("uid1", "pay1_updated", "Payment 1 Updated");
        this.emits(DELETE, this.r("uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_updated", "Payment 1 Updated", "uid1", "s1_updated", "Shipment 1 Updated"), DELETE, this.r("uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_updated", "Payment 1 Updated", "uid1", "s2_another", "Shipment 2 Another"));
        this.insertPayment("uid1", "pay1_final", "Payment 1 Final");
        this.emits(INSERT, this.r("uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_final", "Payment 1 Final", "uid1", "s1_updated", "Shipment 1 Updated"), INSERT, this.r("uid1", "u1_updated", "User 1 Updated", "uid1", "o1_updated", "Order 1 Updated", "uid1", "pay1_final", "Payment 1 Final", "uid1", "s2_another", "Shipment 2 Another"));
    }

    static {
        customAttributeMap.put(1, Collections.singletonList(new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 0, 1, 0)));
        customAttributeMap.put(2, Collections.singletonList(new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 0, 2, 0)));
        customAttributeMap.put(3, Collections.singletonList(new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 0, 3, 0)));
    }
}

