/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.join.Int2HashJoinOperatorTestBase;
import org.apache.flink.table.runtime.operators.join.SortMergeFullOuterJoinIterator;
import org.apache.flink.table.runtime.operators.join.SortMergeInnerJoinIterator;
import org.apache.flink.table.runtime.operators.join.SortMergeOneSideOuterJoinIterator;
import org.apache.flink.table.runtime.operators.sort.IntRecordComparator;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.LazyMemorySegmentPool;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class SortMergeJoinIteratorTest {
    private static final int MEMORY_SIZE = 0x140000;
    private static final int BUFFER_MEMORY = 20;
    private final boolean leftIsSmall;
    private MemoryManager memManager;
    private IOManager ioManager;
    private BinaryRowDataSerializer serializer;

    SortMergeJoinIteratorTest(boolean leftIsSmall) {
        this.leftIsSmall = leftIsSmall;
    }

    @Parameters(name="leftIsSmall = {0}")
    private static Collection<Boolean> parameters() {
        return Arrays.asList(true, false);
    }

    @BeforeEach
    void before() throws MemoryAllocationException {
        this.memManager = MemoryManagerBuilder.newBuilder().setMemorySize(0x140000L).build();
        this.ioManager = new IOManagerAsync();
        this.serializer = new BinaryRowDataSerializer(1);
    }

    @TestTemplate
    void testInner() throws Exception {
        this.inner(this.oneEmpty(), Collections.emptyList());
        this.inner(this.haveNull(), Collections.emptyList());
        this.inner(this.noJoin(), Collections.emptyList());
        this.inner(this.oneAndTwo(), this.newExpect1(2));
        this.inner(this.nmJoin(), this.newExpect1(6));
        this.inner(this.nmMultiJoin(), this.newExpect1(6));
    }

    @TestTemplate
    void testOneSideOuter() throws Exception {
        List<Tuple2<BinaryRowData, BinaryRowData>> compare6;
        List<Tuple2<BinaryRowData, BinaryRowData>> compare5;
        List<Tuple2<BinaryRowData, BinaryRowData>> compare3;
        List<Tuple2<BinaryRowData, BinaryRowData>> compare2;
        List<Tuple2<BinaryRowData, BinaryRowData>> compare1;
        List<Tuple2<BinaryRowData, BinaryRowData>> compare4 = this.newExpect1(2);
        if (!this.leftIsSmall) {
            compare1 = Arrays.asList(this.newTuple(this.newRow(1), null), this.newTuple(this.newRow(2), null));
            compare2 = Collections.singletonList(this.newTuple(this.newRow(null), null));
            compare3 = Collections.singletonList(this.newTuple(this.newRow(1), null));
            compare5 = this.newExpect1(6);
            compare6 = this.newExpect1(6);
            compare6.addAll(Arrays.asList(this.newTuple(this.newRow(3), null), this.newTuple(this.newRow(5), null)));
        } else {
            compare1 = Collections.emptyList();
            compare2 = Arrays.asList(this.newTuple(null, this.newRow(null)), this.newTuple(null, this.newRow(null)));
            compare3 = Collections.emptyList();
            compare5 = this.newExpect1(6);
            compare5.add(this.newTuple(null, this.newRow(null)));
            compare6 = this.newExpect1(6);
            compare6.addAll(Arrays.asList(this.newTuple(null, this.newRow(2)), this.newTuple(null, this.newRow(4))));
        }
        this.oneSideOuter(this.oneEmpty(), compare1);
        this.oneSideOuter(this.haveNull(), compare2);
        this.oneSideOuter(this.noJoin(), compare3);
        this.oneSideOuter(this.oneAndTwo(), compare4);
        this.oneSideOuter(this.nmJoin(), compare5);
        this.oneSideOuter(this.nmMultiJoin(), compare6);
    }

    @TestTemplate
    void testFullOuter() throws Exception {
        this.fullOuter(this.oneEmpty(), Arrays.asList(this.newTuple(this.newRow(1), null), this.newTuple(this.newRow(2), null)));
        this.fullOuter(this.haveNull(), Arrays.asList(this.newTuple(this.newRow(null), null), this.newTuple(null, this.newRow(null)), this.newTuple(null, this.newRow(null))));
        this.fullOuter(this.noJoin(), Collections.singletonList(this.newTuple(this.newRow(1), null)));
        this.fullOuter(this.oneAndTwo(), this.newExpect1(2));
        List<Tuple2<BinaryRowData, BinaryRowData>> compare5 = this.newExpect1(6);
        compare5.add(this.newTuple(null, this.newRow(null)));
        this.fullOuter(this.nmJoin(), compare5);
        List<Tuple2<BinaryRowData, BinaryRowData>> compare6 = this.newExpect1(6);
        compare6.addAll(Arrays.asList(this.newTuple(null, this.newRow(2)), this.newTuple(this.newRow(3), null), this.newTuple(null, this.newRow(4)), this.newTuple(this.newRow(5), null)));
        this.fullOuter(this.nmMultiJoin(), compare6);
    }

    private List<Tuple2<BinaryRowData, BinaryRowData>> newExpect1(int number) {
        ArrayList<Tuple2<BinaryRowData, BinaryRowData>> list = new ArrayList<Tuple2<BinaryRowData, BinaryRowData>>();
        for (int i = 0; i < number; ++i) {
            list.add(this.newTuple(this.newRow(1), this.newRow(1)));
        }
        return list;
    }

    public void inner(Tuple2<MutableObjectIterator<BinaryRowData>, MutableObjectIterator<BinaryRowData>> data, List<Tuple2<BinaryRowData, BinaryRowData>> compare) throws Exception {
        MutableObjectIterator input1 = (MutableObjectIterator)data.f0;
        MutableObjectIterator input2 = (MutableObjectIterator)data.f1;
        if (this.leftIsSmall) {
            input1 = (MutableObjectIterator)data.f1;
            input2 = (MutableObjectIterator)data.f0;
        }
        try (SortMergeInnerJoinIterator iterator = new SortMergeInnerJoinIterator(new BinaryRowDataSerializer(1), new BinaryRowDataSerializer(1), (Projection)new Int2HashJoinOperatorTestBase.MyProjection(), (Projection)new Int2HashJoinOperatorTestBase.MyProjection(), (RecordComparator)new IntRecordComparator(), input1, input2, new ResettableExternalBuffer(this.ioManager, new LazyMemorySegmentPool((Object)this, this.memManager, 20), (AbstractRowDataSerializer)this.serializer, false), new boolean[]{true});){
            int id = 0;
            while (iterator.nextInnerJoin()) {
                RowData probe = iterator.getProbeRow();
                ResettableExternalBuffer.BufferIterator iter = iterator.getMatchBuffer().newIterator();
                while (iter.advanceNext()) {
                    BinaryRowData row = iter.getRow();
                    Tuple2<BinaryRowData, BinaryRowData> expected = compare.get(id++);
                    if (this.leftIsSmall) {
                        Assertions.assertThat((Object)new Tuple2((Object)row, (Object)probe)).isEqualTo(expected);
                        continue;
                    }
                    Assertions.assertThat((Object)new Tuple2((Object)probe, (Object)row)).isEqualTo(expected);
                }
            }
            Assertions.assertThat((int)id).isEqualTo(compare.size());
        }
    }

    public void oneSideOuter(Tuple2<MutableObjectIterator<BinaryRowData>, MutableObjectIterator<BinaryRowData>> data, List<Tuple2<BinaryRowData, BinaryRowData>> compare) throws Exception {
        MutableObjectIterator input1 = (MutableObjectIterator)data.f0;
        MutableObjectIterator input2 = (MutableObjectIterator)data.f1;
        if (this.leftIsSmall) {
            input1 = (MutableObjectIterator)data.f1;
            input2 = (MutableObjectIterator)data.f0;
        }
        try (SortMergeOneSideOuterJoinIterator iterator = new SortMergeOneSideOuterJoinIterator(new BinaryRowDataSerializer(1), new BinaryRowDataSerializer(1), (Projection)new Int2HashJoinOperatorTestBase.MyProjection(), (Projection)new Int2HashJoinOperatorTestBase.MyProjection(), (RecordComparator)new IntRecordComparator(), input1, input2, new ResettableExternalBuffer(this.ioManager, new LazyMemorySegmentPool((Object)this, this.memManager, 20), (AbstractRowDataSerializer)this.serializer, false), new boolean[]{true});){
            int id = 0;
            while (iterator.nextOuterJoin()) {
                RowData probe = iterator.getProbeRow();
                if (iterator.matchKey == null) {
                    Tuple2<BinaryRowData, BinaryRowData> expected = compare.get(id++);
                    if (this.leftIsSmall) {
                        Assertions.assertThat((Object)new Tuple2(null, (Object)probe)).isEqualTo(expected);
                        continue;
                    }
                    Assertions.assertThat((Object)new Tuple2((Object)probe, null)).isEqualTo(expected);
                    continue;
                }
                ResettableExternalBuffer.BufferIterator iter = iterator.getMatchBuffer().newIterator();
                while (iter.advanceNext()) {
                    BinaryRowData row = iter.getRow();
                    Tuple2<BinaryRowData, BinaryRowData> expected = compare.get(id++);
                    Assertions.assertThat((Object)new Tuple2((Object)row, (Object)probe)).isEqualTo(expected);
                }
            }
            Assertions.assertThat((int)id).isEqualTo(compare.size());
        }
    }

    public void fullOuter(Tuple2<MutableObjectIterator<BinaryRowData>, MutableObjectIterator<BinaryRowData>> data, List<Tuple2<BinaryRowData, BinaryRowData>> compare) throws Exception {
        MutableObjectIterator input1 = (MutableObjectIterator)data.f0;
        MutableObjectIterator input2 = (MutableObjectIterator)data.f1;
        try (SortMergeFullOuterJoinIterator iterator = new SortMergeFullOuterJoinIterator(new BinaryRowDataSerializer(1), new BinaryRowDataSerializer(1), (Projection)new Int2HashJoinOperatorTestBase.MyProjection(), (Projection)new Int2HashJoinOperatorTestBase.MyProjection(), (RecordComparator)new IntRecordComparator(), input1, input2, new ResettableExternalBuffer(this.ioManager, new LazyMemorySegmentPool((Object)this, this.memManager, 20), (AbstractRowDataSerializer)this.serializer, false), new ResettableExternalBuffer(this.ioManager, new LazyMemorySegmentPool((Object)this, this.memManager, 20), (AbstractRowDataSerializer)this.serializer, false), new boolean[]{true});){
            int id = 0;
            while (iterator.nextOuterJoin()) {
                Tuple2<BinaryRowData, BinaryRowData> expected;
                BinaryRowData row;
                ResettableExternalBuffer.BufferIterator iter;
                BinaryRowData matchKey = iterator.getMatchKey();
                ResettableExternalBuffer buffer1 = iterator.getBuffer1();
                ResettableExternalBuffer buffer2 = iterator.getBuffer2();
                if (matchKey == null && buffer1.size() > 0) {
                    iter = buffer1.newIterator();
                    while (iter.advanceNext()) {
                        row = iter.getRow();
                        expected = compare.get(id++);
                        Assertions.assertThat((Object)new Tuple2((Object)row, null)).isEqualTo(expected);
                    }
                    continue;
                }
                if (matchKey == null && buffer2.size() > 0) {
                    iter = buffer2.newIterator();
                    while (iter.advanceNext()) {
                        row = iter.getRow();
                        expected = compare.get(id++);
                        Assertions.assertThat((Object)new Tuple2(null, (Object)row)).isEqualTo(expected);
                    }
                    continue;
                }
                if (matchKey != null) {
                    ResettableExternalBuffer.BufferIterator iter1 = buffer1.newIterator();
                    while (iter1.advanceNext()) {
                        BinaryRowData row1 = iter1.getRow();
                        ResettableExternalBuffer.BufferIterator iter2 = buffer2.newIterator();
                        while (iter2.advanceNext()) {
                            BinaryRowData row2 = iter2.getRow();
                            Tuple2<BinaryRowData, BinaryRowData> expected2 = compare.get(id++);
                            Assertions.assertThat((Object)new Tuple2((Object)row1, (Object)row2)).isEqualTo(expected2);
                        }
                    }
                    continue;
                }
                throw new RuntimeException("There is a bug.");
            }
            Assertions.assertThat((int)id).isEqualTo(compare.size());
        }
    }

    private Tuple2<MutableObjectIterator<BinaryRowData>, MutableObjectIterator<BinaryRowData>> oneEmpty() {
        return new Tuple2((Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(2))), (Object)new ListIterator(Collections.emptyList()));
    }

    private Tuple2<MutableObjectIterator<BinaryRowData>, MutableObjectIterator<BinaryRowData>> oneAndTwo() {
        return new Tuple2((Object)new ListIterator(Collections.singletonList(this.newRow(1))), (Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1))));
    }

    private Tuple2<MutableObjectIterator<BinaryRowData>, MutableObjectIterator<BinaryRowData>> haveNull() {
        return new Tuple2((Object)new ListIterator(Collections.singletonList(this.newRow(null))), (Object)new ListIterator(Arrays.asList(this.newRow(null), this.newRow(null))));
    }

    private Tuple2<MutableObjectIterator<BinaryRowData>, MutableObjectIterator<BinaryRowData>> noJoin() {
        return new Tuple2((Object)new ListIterator(Collections.singletonList(this.newRow(1))), (Object)new ListIterator(Collections.emptyList()));
    }

    private Tuple2<MutableObjectIterator<BinaryRowData>, MutableObjectIterator<BinaryRowData>> nmJoin() {
        return new Tuple2((Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1))), (Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1), this.newRow(1), this.newRow(null))));
    }

    private Tuple2<MutableObjectIterator<BinaryRowData>, MutableObjectIterator<BinaryRowData>> nmMultiJoin() {
        return new Tuple2((Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1), this.newRow(3), this.newRow(5))), (Object)new ListIterator(Arrays.asList(this.newRow(1), this.newRow(1), this.newRow(1), this.newRow(2), this.newRow(4))));
    }

    public BinaryRowData newRow(Integer i) {
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        if (i != null) {
            writer.writeInt(0, i.intValue());
        } else {
            writer.setNullAt(0);
        }
        writer.complete();
        return row;
    }

    public Tuple2<BinaryRowData, BinaryRowData> newTuple(BinaryRowData i, BinaryRowData j) {
        return new Tuple2((Object)i, (Object)j);
    }

    public static class ListIterator
    implements MutableObjectIterator<BinaryRowData> {
        private List<BinaryRowData> list;
        private int index = 0;

        public ListIterator(List<BinaryRowData> list) {
            this.list = list;
        }

        public BinaryRowData next(BinaryRowData binaryRow) throws IOException {
            return this.next();
        }

        public BinaryRowData next() throws IOException {
            if (this.index < this.list.size()) {
                return this.list.get(this.index++);
            }
            return null;
        }
    }
}

