/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.bundle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.operators.join.stream.bundle.BufferBundle;

public class InputSideHasUniqueKeyBundle
extends BufferBundle<Map<RowData, List<RowData>>> {
    @Override
    public int addRecord(RowData joinKey, RowData uniqueKey, RowData record) {
        this.bundle.computeIfAbsent(joinKey, k -> new HashMap()).computeIfAbsent(uniqueKey, k -> new ArrayList());
        if (!this.foldRecord(joinKey, uniqueKey, record)) {
            ++this.actualSize;
            this.bundle.computeIfAbsent(joinKey, k -> new HashMap()).computeIfAbsent(uniqueKey, key -> new ArrayList()).add(record);
        }
        return ++this.count;
    }

    @Override
    public Map<RowData, List<RowData>> getRecords() {
        HashMap<RowData, List<RowData>> result = new HashMap<RowData, List<RowData>>();
        for (RowData joinKey : this.bundle.keySet()) {
            List list = result.computeIfAbsent(joinKey, key -> new ArrayList());
            ((Map)this.bundle.get(joinKey)).values().stream().flatMap(Collection::stream).forEach(list::add);
        }
        return result;
    }

    @Override
    public Set<RowData> getJoinKeys() {
        return this.bundle.keySet();
    }

    @Override
    public Map<RowData, List<RowData>> getRecordsWithJoinKey(RowData joinKey) {
        return (Map)this.bundle.get(joinKey);
    }

    private boolean foldRecord(RowData joinKey, RowData uniqueKey, RowData record) {
        Optional prevRecord;
        List list = (List)((Map)this.bundle.get(joinKey)).get(uniqueKey);
        boolean shouldFoldRecord = false;
        Optional<Object> optional = prevRecord = list.isEmpty() ? Optional.empty() : Optional.of((RowData)list.get(list.size() - 1));
        if (prevRecord.isPresent()) {
            RowData last = (RowData)prevRecord.get();
            if (RowDataUtil.isAccumulateMsg(last)) {
                if (RowDataUtil.isRetractMsg(record)) {
                    shouldFoldRecord = true;
                }
                --this.actualSize;
                list.remove(list.size() - 1);
                if (list.isEmpty() && shouldFoldRecord) {
                    ((Map)this.bundle.get(joinKey)).remove(uniqueKey);
                    if (((Map)this.bundle.get(joinKey)).isEmpty()) {
                        this.bundle.remove(joinKey);
                    }
                }
            } else if (RowDataUtil.isRetractMsg(record)) {
                --this.actualSize;
                list.remove(list.size() - 1);
            }
        }
        return shouldFoldRecord;
    }
}

