/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup.keyordered;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KeyAccountingUnit<K> {
    private final Map<K, Object> noConflictInFlightRecords = new ConcurrentHashMap<K, Object>();

    public boolean occupy(Object record, K key) {
        return this.noConflictInFlightRecords.putIfAbsent(key, record) == null;
    }

    public boolean ifOccupy(K key) {
        return !this.noConflictInFlightRecords.containsKey(key);
    }

    public void release(Object record, K key) {
        if (this.noConflictInFlightRecords.remove(key) != record) {
            throw new IllegalStateException(String.format("The record %s(%s) is trying to release key which it actually does not hold.", record, key));
        }
    }
}

