/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.aggregate;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.NullNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.util.RawValue;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.functions.SqlJsonUtils;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public class JsonObjectAggFunction
extends BuiltInAggregateFunction<String, Accumulator> {
    private static final long serialVersionUID = 1L;
    private static final StringData NULL_STRING_DATA = StringData.fromBytes((byte[])new byte[0]);
    private static final NullNode NULL_NODE = SqlJsonUtils.getNodeFactory().nullNode();
    private final transient List<DataType> argumentTypes;
    private final boolean skipNulls;

    public JsonObjectAggFunction(LogicalType[] argumentTypes, boolean skipNulls) {
        this.argumentTypes = Arrays.stream(argumentTypes).map(DataTypeUtils::toInternalDataType).collect(Collectors.toList());
        this.skipNulls = skipNulls;
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return this.argumentTypes;
    }

    @Override
    public DataType getOutputDataType() {
        return DataTypes.STRING();
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(Accumulator.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"map", (DataType)MapView.newMapViewDataType((DataType)((DataType)DataTypes.STRING().notNull()).toInternal(), (DataType)DataTypes.STRING().toInternal()))});
    }

    public Accumulator createAccumulator() {
        return new Accumulator();
    }

    public void resetAccumulator(Accumulator acc) {
        acc.map.clear();
    }

    public void accumulate(Accumulator acc, StringData keyData, @Nullable StringData valueData) throws Exception {
        JsonObjectAggFunction.assertKeyNotPresent(acc, keyData);
        if (valueData == null) {
            if (!this.skipNulls) {
                acc.map.put((Object)keyData, (Object)NULL_STRING_DATA);
            }
        } else {
            acc.map.put((Object)keyData, (Object)valueData);
        }
    }

    public void retract(Accumulator acc, StringData keyData, @Nullable StringData valueData) throws Exception {
        acc.map.remove((Object)keyData);
    }

    public void merge(Accumulator acc, Iterable<Accumulator> others) throws Exception {
        for (Accumulator other : others) {
            for (StringData key : other.map.keys()) {
                JsonObjectAggFunction.assertKeyNotPresent(acc, key);
                acc.map.put((Object)key, (Object)((StringData)other.map.get((Object)key)));
            }
        }
    }

    public String getValue(Accumulator acc) {
        ObjectNode rootNode = SqlJsonUtils.createObjectNode();
        try {
            for (StringData key : acc.map.keys()) {
                StringData value = (StringData)acc.map.get((Object)key);
                NullNode valueNode = value.toBytes().length == 0 ? NULL_NODE : SqlJsonUtils.getNodeFactory().rawValueNode(new RawValue(value.toString()));
                rootNode.set(key.toString(), (JsonNode)valueNode);
            }
        }
        catch (Exception e) {
            throw new TableException("The accumulator state could not be serialized.", (Throwable)e);
        }
        return SqlJsonUtils.serializeJson((JsonNode)rootNode);
    }

    private static void assertKeyNotPresent(Accumulator acc, StringData keyData) throws Exception {
        if (acc.map.contains((Object)keyData)) {
            throw new TableException(String.format("Key '%s' is already present. Duplicate keys are not allowed in JSON_OBJECTAGG. Please ensure that keys are unique.", keyData.toString()));
        }
    }

    public static class Accumulator {
        public MapView<StringData, StringData> map = new MapView();

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Accumulator that = (Accumulator)other;
            return Objects.equals(this.map, that.map);
        }

        public int hashCode() {
            return Objects.hash(this.map);
        }
    }
}

