/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.codesplit.CodeRewriter;
import org.apache.flink.table.codesplit.CodeSplitUtil;
import org.apache.flink.table.codesplit.JavaLexer;
import org.apache.flink.table.codesplit.JavaParser;
import org.apache.flink.table.codesplit.JavaParserBaseVisitor;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CharStreams;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.TokenStreamRewriter;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.PredictionMode;

@Internal
public class AddBoolBeforeReturnRewriter
implements CodeRewriter {
    private final int maxMethodLength;
    private final CommonTokenStream tokenStream;
    private final TokenStreamRewriter rewriter;
    private final List<Map<String, String>> boolVarNames;

    public AddBoolBeforeReturnRewriter(String code, int maxMethodLength) {
        this.maxMethodLength = maxMethodLength;
        this.tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(code)));
        this.rewriter = new TokenStreamRewriter(this.tokenStream);
        this.boolVarNames = new ArrayList<Map<String, String>>();
    }

    @Override
    public String rewrite() {
        OuterVisitor visitor = new OuterVisitor();
        JavaParser javaParser = new JavaParser(this.tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        visitor.visit(javaParser.compilationUnit());
        return this.rewriter.getText();
    }

    public List<Map<String, String>> getBoolVarNames() {
        return this.boolVarNames;
    }

    private class InnerVisitor
    extends JavaParserBaseVisitor<Void> {
        private final String key;
        private final String boolVarName;

        private InnerVisitor(String key, String boolVarName) {
            this.key = key;
            this.boolVarName = boolVarName;
        }

        @Override
        public Void visitClassBody(JavaParser.ClassBodyContext ctx) {
            return null;
        }

        @Override
        public Void visitLambdaBody(JavaParser.LambdaBodyContext ctx) {
            return null;
        }

        @Override
        public Void visitStatement(JavaParser.StatementContext ctx) {
            if (ctx.RETURN() != null) {
                String newReturnStatement = String.format("{ %s = true; return; }", this.boolVarName);
                AddBoolBeforeReturnRewriter.this.rewriter.replace(ctx.start, ctx.stop, (Object)newReturnStatement);
                AddBoolBeforeReturnRewriter.this.boolVarNames.get(AddBoolBeforeReturnRewriter.this.boolVarNames.size() - 1).put(this.key, this.boolVarName);
            }
            return (Void)this.visitChildren(ctx);
        }
    }

    private class OuterVisitor
    extends JavaParserBaseVisitor<Void> {
        private OuterVisitor() {
        }

        @Override
        public Void visitClassBody(JavaParser.ClassBodyContext ctx) {
            HashMap classBoolNames = new HashMap();
            AddBoolBeforeReturnRewriter.this.boolVarNames.add(classBoolNames);
            Void ret = (Void)this.visitChildren(ctx);
            for (String varName : classBoolNames.values()) {
                AddBoolBeforeReturnRewriter.this.rewriter.insertAfter(ctx.start, (Object)String.format("\nboolean %s;", varName));
            }
            return ret;
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if (!"void".equals(ctx.typeTypeOrVoid().getText())) {
                return null;
            }
            long methodBodyLength = CodeSplitUtil.getContextTextLength(ctx.methodBody().block());
            if (methodBodyLength < (long)AddBoolBeforeReturnRewriter.this.maxMethodLength) {
                return null;
            }
            if (ctx.methodBody().block().blockStatement() == null || ctx.methodBody().block().blockStatement().size() <= 1) {
                return null;
            }
            String functionName = ctx.IDENTIFIER().getText();
            String parameters = CodeSplitUtil.getContextString(ctx.formalParameters());
            String boolVarName = CodeSplitUtil.newName(functionName + "HasReturned");
            InnerVisitor visitor = new InnerVisitor(functionName + parameters, boolVarName);
            visitor.visitMethodDeclaration(ctx);
            return null;
        }
    }
}

