/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.types.IntValue;
import org.apache.flink.util.MutableObjectIterator;

public final class ConstantsKeyValuePairsIterator
implements MutableObjectIterator<BinaryRowData> {
    private final IntValue key;
    private final IntValue value;
    private int numLeft;

    public ConstantsKeyValuePairsIterator(int key, int value, int count) {
        this.key = new IntValue(key);
        this.value = new IntValue(value);
        this.numLeft = count;
    }

    public BinaryRowData next(BinaryRowData reuse) {
        if (this.numLeft > 0) {
            --this.numLeft;
            BinaryRowWriter writer = new BinaryRowWriter(reuse);
            writer.writeInt(0, this.key.getValue());
            writer.writeInt(1, this.value.getValue());
            writer.complete();
            return reuse;
        }
        return null;
    }

    public BinaryRowData next() {
        return this.next(new BinaryRowData(2));
    }
}

