/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.runtime.typeutils.ExternalSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;

abstract class ExternalSerializerTest<T>
extends SerializerTestInstance<T> {
    ExternalSerializerTest(TestSpec<T> testSpec) {
        super((TypeSerializer)ExternalSerializer.of((DataType)testSpec.dataType), testSpec.dataType.getConversionClass(), testSpec.length, testSpec.instances.toArray((Object[])Array.newInstance(testSpec.dataType.getConversionClass(), 0)));
    }

    protected boolean allowNullInstances(TypeSerializer<T> serializer) {
        return true;
    }

    public static class ImmutableTestPojo {
        public final int age;
        public final String name;

        public ImmutableTestPojo(int age, String name) {
            this.age = age;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableTestPojo that = (ImmutableTestPojo)o;
            return this.age == that.age && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.age, this.name);
        }
    }

    private static class TestSpec<T> {
        private final DataType dataType;
        private final List<T> instances = new ArrayList<T>();
        private int length = -1;

        private TestSpec(DataType dataType) {
            this.dataType = dataType;
        }

        static <T> TestSpec<T> forDataType(DataType dataType) {
            return new TestSpec<T>(dataType);
        }

        TestSpec<T> withLength(int length) {
            this.length = length;
            return this;
        }

        TestSpec<T> addInstance(T instance) {
            this.instances.add(instance);
            return this;
        }

        public String toString() {
            return this.dataType.toString();
        }
    }

    static final class ExternalSerializer5Test
    extends ExternalSerializerTest {
        public ExternalSerializer5Test() {
            super(TestSpec.forDataType(DataTypes.ARRAY((DataType)DataTypes.INT())).addInstance(new Integer[]{0, 1, null, 3}).addInstance(new Integer[0]));
        }
    }

    static final class ExternalSerializer4Test
    extends ExternalSerializerTest {
        public ExternalSerializer4Test() {
            super(TestSpec.forDataType((DataType)DataTypes.ARRAY((DataType)DataTypes.STRUCTURED(ImmutableTestPojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())})).bridgedTo(List.class)).addInstance(Collections.singletonList(new ImmutableTestPojo(12, "Bob"))).addInstance(Arrays.asList(new ImmutableTestPojo(42, "Alice"), null, null, new ImmutableTestPojo(42, null))));
        }
    }

    static final class ExternalSerializer3Test
    extends ExternalSerializerTest {
        public ExternalSerializer3Test() {
            super(TestSpec.forDataType(DataTypes.STRUCTURED(ImmutableTestPojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())})).addInstance(new ImmutableTestPojo(12, "Bob")).addInstance(new ImmutableTestPojo(42, null)));
        }
    }

    static final class ExternalSerializer2Test
    extends ExternalSerializerTest {
        public ExternalSerializer2Test() {
            super(TestSpec.forDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())})).addInstance(Row.of((Object[])new Object[]{12, "Bob"})).addInstance(Row.of((Object[])new Object[]{42, null})));
        }
    }

    static final class ExternalSerializer1Test
    extends ExternalSerializerTest {
        public ExternalSerializer1Test() {
            super(TestSpec.forDataType(DataTypes.INT()).withLength(4).addInstance(18).addInstance(42));
        }
    }
}

