/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.runtimefilter;

import java.io.Serializable;
import java.util.Queue;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfData;
import org.apache.flink.runtime.io.network.api.StopMode;
import org.apache.flink.runtime.operators.util.BloomFilter;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskMailboxTestHarness;
import org.apache.flink.streaming.runtime.tasks.StreamTaskMailboxTestHarnessBuilder;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.operators.runtimefilter.LocalRuntimeFilterBuilderOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

public class LocalRuntimeFilterBuilderOperatorTest
implements Serializable {
    @Test
    void testNormalOutput() throws Exception {
        try (StreamTaskMailboxTestHarness<RowData> testHarness = LocalRuntimeFilterBuilderOperatorTest.createLocalRuntimeFilterBuilderOperatorHarnessAndProcessElements(5, 10);){
            Queue outputs = testHarness.getOutput();
            AssertionsForClassTypes.assertThat((int)outputs.size()).isEqualTo(1);
            RowData outputRowData = (RowData)((StreamRecord)outputs.poll()).getValue();
            AssertionsForClassTypes.assertThat((int)outputRowData.getArity()).isEqualTo(2);
            int actualCount = outputRowData.getInt(0);
            BloomFilter bloomFilter = BloomFilter.fromBytes((byte[])outputRowData.getBinary(1));
            AssertionsForClassTypes.assertThat((int)actualCount).isEqualTo(5);
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var1")).isTrue();
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var2")).isTrue();
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var3")).isTrue();
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var4")).isTrue();
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var5")).isTrue();
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var6")).isFalse();
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var7")).isFalse();
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var8")).isFalse();
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var9")).isFalse();
            AssertionsForClassTypes.assertThat((boolean)LocalRuntimeFilterBuilderOperatorTest.bloomFilterTestString(bloomFilter, "var10")).isFalse();
        }
    }

    @Test
    void testOverMaxRowCountOutput() throws Exception {
        try (StreamTaskMailboxTestHarness<RowData> testHarness = LocalRuntimeFilterBuilderOperatorTest.createLocalRuntimeFilterBuilderOperatorHarnessAndProcessElements(3, 4);){
            Queue outputs = testHarness.getOutput();
            AssertionsForClassTypes.assertThat((int)outputs.size()).isEqualTo(1);
            RowData outputRowData = (RowData)((StreamRecord)outputs.poll()).getValue();
            AssertionsForClassTypes.assertThat((int)outputRowData.getArity()).isEqualTo(2);
            int actualCount = outputRowData.getInt(0);
            AssertionsForClassTypes.assertThat((int)actualCount).isEqualTo(-1);
            AssertionsForClassTypes.assertThat((boolean)outputRowData.isNullAt(1)).isTrue();
        }
    }

    private static boolean bloomFilterTestString(BloomFilter bloomFilter, String string) {
        FirstStringFieldProjection projection = new FirstStringFieldProjection();
        return bloomFilter.testHash(((BinaryRowData)projection.apply((RowData)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)string)}))).hashCode());
    }

    public static StreamRecord<RowData> createRowDataRecord(String string, int integer) {
        return new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)string), integer}));
    }

    public static StreamTaskMailboxTestHarness<RowData> createLocalRuntimeFilterBuilderOperatorHarnessAndProcessElements(int estimatedRowCount, int maxRowCount) throws Exception {
        GeneratedProjection buildProjectionCode = new GeneratedProjection("", "", new Object[0]){

            public Projection newInstance(ClassLoader classLoader) {
                return new FirstStringFieldProjection();
            }
        };
        InternalTypeInfo inputType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new VarCharType(), new IntType()});
        LocalRuntimeFilterBuilderOperator operator = new LocalRuntimeFilterBuilderOperator(buildProjectionCode, estimatedRowCount, maxRowCount);
        StreamTaskMailboxTestHarness testHarness = new StreamTaskMailboxTestHarnessBuilder(OneInputStreamTask::new, (TypeInformation)InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new IntType(), new BinaryType()})).setupOutputForSingletonOperatorChain((StreamOperator)operator).addInput((TypeInformation)inputType).build();
        testHarness.processElement(LocalRuntimeFilterBuilderOperatorTest.createRowDataRecord("var1", 111));
        testHarness.processElement(LocalRuntimeFilterBuilderOperatorTest.createRowDataRecord("var2", 222));
        testHarness.processElement(LocalRuntimeFilterBuilderOperatorTest.createRowDataRecord("var3", 333));
        testHarness.processElement(LocalRuntimeFilterBuilderOperatorTest.createRowDataRecord("var4", 444));
        testHarness.processElement(LocalRuntimeFilterBuilderOperatorTest.createRowDataRecord("var5", 555));
        testHarness.processEvent((AbstractEvent)new EndOfData(StopMode.DRAIN), 0);
        return testHarness;
    }

    static final class FirstStringFieldProjection
    implements Projection<RowData, BinaryRowData> {
        BinaryRowData innerRow = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(this.innerRow);

        FirstStringFieldProjection() {
        }

        public BinaryRowData apply(RowData row) {
            this.writer.reset();
            this.writer.writeString(0, row.getString(0));
            this.writer.complete();
            return this.innerRow;
        }
    }
}

