/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.FastTop1Function;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.TopNFunctionTestBase;
import org.apache.flink.table.runtime.operators.rank.async.AsyncStateFastTop1Function;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.jupiter.api.TestTemplate;

public class FastTop1FunctionTest
extends TopNFunctionTestBase {
    @Override
    AbstractTopNFunction createFunction(RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber, boolean enableAsyncState) {
        if (enableAsyncState) {
            return new AsyncStateFastTop1Function(this.ttlConfig, this.inputRowType, generatedSortKeyComparator, this.sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber, this.cacheSize);
        }
        return new FastTop1Function(this.ttlConfig, this.inputRowType, generatedSortKeyComparator, this.sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber, this.cacheSize);
    }

    @Override
    boolean supportedAsyncState() {
        return true;
    }

    @Override
    void testDisableGenerateUpdateBefore() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), false, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 11));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 5L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Override
    void testOutputRankNumberWithConstantRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), true, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 5L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Override
    void testDisableGenerateUpdateBeforeAndOutputRankNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), false, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 5L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Override
    void testConstantRankRangeWithoutOffset() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), true, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 11));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 4L, 33));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 5L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        expectedOutput.clear();
        func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), true, false);
        testHarness = this.createTestHarness(func);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 5L, 10));
        testHarness.close();
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 4L, 11));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 5L, 10));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @TestTemplate
    void testVariableRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), true, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 18));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 18));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 1L, 44));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 1L, 44));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 1L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @TestTemplate
    void testOutputRankNumberWithUpdateInputs() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), true, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 12));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 1L, 44, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 1L, 44, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 1L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @TestTemplate
    void testSortKeyChangesWhenOutputRankNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), true, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 16, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 3L, 16, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 2, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 4L, 2, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 1, 1L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @TestTemplate
    void testSortKeyChangesWhenOutputRankNumberAndNotGenerateUpdateBefore() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), false, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 16, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 2, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 1, 1L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @TestTemplate
    void testSortKeyChangesWhenNotOutputRankNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), true, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 16));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 3L, 16));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 2));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 4L, 2));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @TestTemplate
    void testSortKeyChangesWhenNotOutputRankNumberAndNotGenerateUpdateBefore() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 1L), false, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 16));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 2));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Override
    void testConstantRankRangeWithOffset() throws Exception {
    }

    @Override
    void testOutputRankNumberWithVariableRankRange() throws Exception {
    }
}

