/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.multijoin;

import java.util.List;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.multijoin.StreamingMultiJoinOperatorTestBase;
import org.apache.flink.table.runtime.util.StateParameterizedHarnessTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamingTwoWayOuterMultiJoinOperatorTest
extends StreamingMultiJoinOperatorTestBase {
    public StreamingTwoWayOuterMultiJoinOperatorTest(StateParameterizedHarnessTestBase.StateBackendMode stateBackendMode) {
        super(stateBackendMode, 2, List.of(FlinkJoinType.INNER, FlinkJoinType.LEFT), StreamingTwoWayOuterMultiJoinOperatorTest.defaultConditions(), false);
    }

    @TestTemplate
    void testTwoWayLeftOuterJoin() throws Exception {
        this.insertUser("1", "Gus", "User 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", null, null, null);
        this.insertOrder("2", "order_2", "Order 2 Details");
        this.emitsNothing();
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", null, null, null), INSERT, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details"));
        this.deleteOrder("1", "order_1", "Order 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details"), INSERT, this.r("1", "Gus", "User 1 Details", null, null, null));
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", null, null, null), INSERT, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details"));
        this.deleteUser("1", "Gus", "User 1 Details");
        this.emits(DELETE, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details");
        this.insertUser("1", "Gus", "User 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details");
        this.updateBeforeUser("1", "Gus", "User 1 Details");
        this.emits(UPDATE_BEFORE, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details");
        this.updateAfterUser("1", "Gus", "User 1 Details Updated");
        this.emits(UPDATE_AFTER, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details");
        this.updateAfterUser("1", "Gus", "User 1 Details Updated 2");
        this.emits(UPDATE_AFTER, "1", "Gus", "User 1 Details Updated 2", "1", "order_1", "Order 1 Details");
        this.updateBeforeOrder("1", "order_1", "Order 1 Details");
        this.emits(UPDATE_BEFORE, this.r("1", "Gus", "User 1 Details Updated 2", "1", "order_1", "Order 1 Details"), INSERT, this.r("1", "Gus", "User 1 Details Updated 2", null, null, null));
        this.updateAfterOrder("1", "order_1", "Order 1 Details Updated");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details Updated 2", null, null, null), UPDATE_AFTER, this.r("1", "Gus", "User 1 Details Updated 2", "1", "order_1", "Order 1 Details Updated"));
        this.updateAfterOrder("1", "order_1", "Order 1 Details Updated 2");
        this.emits(UPDATE_AFTER, "1", "Gus", "User 1 Details Updated 2", "1", "order_1", "Order 1 Details Updated 2");
        this.insertOrder("1", "order_2", "Order 2 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details Updated 2", "1", "order_2", "Order 2 Details");
        this.deleteUser("1", "Gus", "User 1 Details Updated 2");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details Updated 2", "1", "order_2", "Order 2 Details"), DELETE, this.r("1", "Gus", "User 1 Details Updated 2", "1", "order_1", "Order 1 Details Updated 2"));
        this.insertUser("1", "Dawid", "User 3 Details");
        this.emits(INSERT, this.r("1", "Dawid", "User 3 Details", "1", "order_2", "Order 2 Details"), INSERT, this.r("1", "Dawid", "User 3 Details", "1", "order_1", "Order 1 Details Updated 2"));
    }
}

