/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.multijoin;

import java.util.List;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.multijoin.StreamingMultiJoinOperatorTestBase;
import org.apache.flink.table.runtime.util.StateParameterizedHarnessTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamingThreeWayOuterJoinOperatorTest
extends StreamingMultiJoinOperatorTestBase {
    public StreamingThreeWayOuterJoinOperatorTest(StateParameterizedHarnessTestBase.StateBackendMode stateBackendMode) {
        super(stateBackendMode, 3, List.of(FlinkJoinType.INNER, FlinkJoinType.LEFT, FlinkJoinType.LEFT), StreamingThreeWayOuterJoinOperatorTest.defaultConditions(), false);
    }

    @TestTemplate
    void testThreeWayLeftOuterJoin() throws Exception {
        this.insertUser("1", "Gus", "User 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", null, null, null, null, null, null);
        this.insertOrder("2", "order_2", "Order 2 Details");
        this.emitsNothing();
        this.insertPayment("3", "payment_3", "Payment 3 Details");
        this.emitsNothing();
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", null, null, null, null, null, null), INSERT, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", null, null, null));
        this.insertPayment("1", "payment_1", "Payment 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", null, null, null), INSERT, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details"));
        this.deletePayment("1", "payment_1", "Payment 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details"), INSERT, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", null, null, null));
        this.deleteOrder("1", "order_1", "Order 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", null, null, null), INSERT, this.r("1", "Gus", "User 1 Details", null, null, null, null, null, null));
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", null, null, null, null, null, null), INSERT, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", null, null, null));
        this.insertPayment("1", "payment_1", "Payment 1 Details");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", null, null, null), INSERT, this.r("1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details"));
        this.deleteUser("1", "Gus", "User 1 Details");
        this.emits(DELETE, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details");
        this.insertUser("1", "Gus", "User 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details");
        this.updateBeforeUser("1", "Gus", "User 1 Details");
        this.emits(UPDATE_BEFORE, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details");
        this.updateAfterUser("1", "Gus", "User 1 Details Updated");
        this.emits(UPDATE_AFTER, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details");
        this.updateBeforeOrder("1", "order_1", "Order 1 Details");
        this.emits(UPDATE_BEFORE, this.r("1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details"), INSERT, this.r("1", "Gus", "User 1 Details Updated", null, null, null, null, null, null));
        this.updateAfterOrder("1", "order_1", "Order 1 Details Updated");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details Updated", null, null, null, null, null, null), UPDATE_AFTER, this.r("1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 Details"));
        this.updateBeforePayment("1", "payment_1", "Payment 1 Details");
        this.emits(UPDATE_BEFORE, this.r("1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 Details"), INSERT, this.r("1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", null, null, null));
        this.updateAfterPayment("1", "payment_1", "Payment 1 Details Updated");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", null, null, null), UPDATE_AFTER, this.r("1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 Details Updated"));
        this.insertPayment("1", "payment_2", "Payment 2 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_2", "Payment 2 Details");
        this.deleteUser("1", "Gus", "User 1 Details Updated");
        this.emits(DELETE, this.r("1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_2", "Payment 2 Details"), DELETE, this.r("1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 Details Updated"));
        this.insertUser("1", "Dawid", "User 3 Details");
        this.emits(INSERT, this.r("1", "Dawid", "User 3 Details", "1", "order_1", "Order 1 Details Updated", "1", "payment_2", "Payment 2 Details"), INSERT, this.r("1", "Dawid", "User 3 Details", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 Details Updated"));
        this.insertPayment("2", "payment_3", "Payment 3 Details");
        this.emitsNothing();
        this.insertPayment("2", "payment_4", "Payment 4 Details");
        this.emitsNothing();
        this.insertUser("2", "Bob", "User 2 Details");
        this.emits(INSERT, this.r("2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_4", "Payment 4 Details"), INSERT, this.r("2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_3", "Payment 3 Details"));
        this.deleteOrder("2", "order_2", "Order 2 Details");
        this.emits(DELETE, this.r("2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_4", "Payment 4 Details"), DELETE, this.r("2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_3", "Payment 3 Details"), INSERT, this.r("2", "Bob", "User 2 Details", null, null, null, null, null, null));
        this.insertOrder("2", "order_2", "Order 2 Details");
        this.emits(DELETE, this.r("2", "Bob", "User 2 Details", null, null, null, null, null, null), INSERT, this.r("2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_4", "Payment 4 Details"), INSERT, this.r("2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_3", "Payment 3 Details"));
        this.insertOrder("2", "order_3", "Order 3 Details");
        this.emits(INSERT, this.r("2", "Bob", "User 2 Details", "2", "order_3", "Order 3 Details", "2", "payment_4", "Payment 4 Details"), INSERT, this.r("2", "Bob", "User 2 Details", "2", "order_3", "Order 3 Details", "2", "payment_3", "Payment 3 Details"));
        this.updateAfterPayment("2", "payment_4", "Payment 4 Details Updated");
        this.emits(UPDATE_AFTER, this.r("2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_4", "Payment 4 Details Updated"), UPDATE_AFTER, this.r("2", "Bob", "User 2 Details", "2", "order_3", "Order 3 Details", "2", "payment_4", "Payment 4 Details Updated"));
        this.updateAfterUser("2", "Bob", "User 2 Details Updated");
        this.emits(UPDATE_AFTER, this.r("2", "Bob", "User 2 Details Updated", "2", "order_2", "Order 2 Details", "2", "payment_4", "Payment 4 Details Updated"), UPDATE_AFTER, this.r("2", "Bob", "User 2 Details Updated", "2", "order_2", "Order 2 Details", "2", "payment_3", "Payment 3 Details"), UPDATE_AFTER, this.r("2", "Bob", "User 2 Details Updated", "2", "order_3", "Order 3 Details", "2", "payment_4", "Payment 4 Details Updated"), UPDATE_AFTER, this.r("2", "Bob", "User 2 Details Updated", "2", "order_3", "Order 3 Details", "2", "payment_3", "Payment 3 Details"));
        this.deleteUser("2", "Bob", "User 2 Details");
        this.emits(DELETE, this.r("2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_4", "Payment 4 Details Updated"), DELETE, this.r("2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_3", "Payment 3 Details"), DELETE, this.r("2", "Bob", "User 2 Details", "2", "order_3", "Order 3 Details", "2", "payment_4", "Payment 4 Details Updated"), DELETE, this.r("2", "Bob", "User 2 Details", "2", "order_3", "Order 3 Details", "2", "payment_3", "Payment 3 Details"));
    }
}

