/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.multijoin;

import java.util.List;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.multijoin.StreamingMultiJoinOperatorTestBase;
import org.apache.flink.table.runtime.util.StateParameterizedHarnessTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamingThreeWayJoinOperatorTest
extends StreamingMultiJoinOperatorTestBase {
    public StreamingThreeWayJoinOperatorTest(StateParameterizedHarnessTestBase.StateBackendMode stateBackendMode) {
        super(stateBackendMode, 3, List.of(FlinkJoinType.INNER, FlinkJoinType.INNER, FlinkJoinType.INNER), StreamingThreeWayJoinOperatorTest.defaultConditions(), false);
    }

    @TestTemplate
    void testThreeWayInnerJoin() throws Exception {
        this.insertUser("1", "Gus", "User 1 Details");
        this.emitsNothing();
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.emitsNothing();
        this.insertPayment("1", "payment_1", "Payment 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details");
        this.insertUser("2", "Bob", "User 2 Details");
        this.insertOrder("2", "order_2", "Order 2 Details");
        this.emitsNothing();
        this.insertPayment("2", "payment_2", "Payment 2 Details");
        this.emits(INSERT, "2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_2", "Payment 2 Details");
    }

    @TestTemplate
    void testThreeWayInnerJoinUpdating() throws Exception {
        this.insertUser("1", "Gus", "User 1 Details");
        this.insertOrder("1", "order_1", "Order 1 Details");
        this.insertPayment("1", "payment_1", "Payment 1 Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details");
        this.updateAfterUser("1", "Gus", "User 1 Details Updated");
        this.emits(UPDATE_AFTER, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details", "1", "payment_1", "Payment 1 Details");
        this.updateAfterOrder("1", "order_1", "Order 1 Details Updated");
        this.emits(UPDATE_AFTER, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 Details");
        this.updateAfterPayment("1", "payment_1", "Payment 1 Details Updated");
        this.emits(UPDATE_AFTER, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 Details Updated");
        this.deletePayment("1", "payment_1", "Payment 1 Details Updated");
        this.emits(DELETE, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 Details Updated");
        this.insertPayment("1", "payment_1", "Payment 1 New Details");
        this.emits(INSERT, "1", "Gus", "User 1 Details Updated", "1", "order_1", "Order 1 Details Updated", "1", "payment_1", "Payment 1 New Details");
        this.insertUser("2", "Bob", "User 2 Details");
        this.insertOrder("2", "order_2", "Order 2 Details");
        this.insertPayment("2", "payment_2", "Payment 2 Details");
        this.emits(INSERT, "2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_2", "Payment 2 Details");
        this.deleteUser("2", "Bob", "User 2 Details");
        this.emits(DELETE, "2", "Bob", "User 2 Details", "2", "order_2", "Order 2 Details", "2", "payment_2", "Payment 2 Details");
        this.insertUser("2", "Bob_Updated", "User 2 Details Updated");
        this.emits(INSERT, "2", "Bob_Updated", "User 2 Details Updated", "2", "order_2", "Order 2 Details", "2", "payment_2", "Payment 2 Details");
        this.insertPayment("2", "payment_3", "Payment 3 Details");
        this.emits(INSERT, "2", "Bob_Updated", "User 2 Details Updated", "2", "order_2", "Order 2 Details", "2", "payment_3", "Payment 3 Details");
    }
}

