/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.multijoin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.keyselector.AttributeBasedJoinKeyExtractor;
import org.apache.flink.table.runtime.operators.join.stream.multijoin.StreamingMultiJoinOperatorTestBase;
import org.apache.flink.table.runtime.util.StateParameterizedHarnessTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StreamingMultiConditionJoinOperatorTest
extends StreamingMultiJoinOperatorTestBase {
    private static final GeneratedJoinCondition multiCondition = StreamingMultiConditionJoinOperatorTest.createAndCondition(StreamingMultiConditionJoinOperatorTest.createJoinCondition(1, 0), StreamingMultiConditionJoinOperatorTest.createCustomIndexJoinCondition(2, 2));
    private static final List<GeneratedJoinCondition> customJoinConditions = Arrays.asList(null, multiCondition);
    private static final Map<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>> customAttributeMap = new HashMap<Integer, List<AttributeBasedJoinKeyExtractor.ConditionAttributeRef>>();

    public StreamingMultiConditionJoinOperatorTest(StateParameterizedHarnessTestBase.StateBackendMode stateBackendMode) {
        super(stateBackendMode, 2, List.of(FlinkJoinType.INNER, FlinkJoinType.INNER), customJoinConditions, customAttributeMap, false);
    }

    @TestTemplate
    void testTwoWayInnerJoinMultiCondition() throws Exception {
        this.insertUser("1", "uid_a", "detail_1");
        this.emitsNothing();
        this.insertOrder("1", "oid_b1", "detail_X");
        this.emitsNothing();
        this.insertOrder("1", "oid_c1", "detail_1");
        this.emits(INSERT, "1", "uid_a", "detail_1", "1", "oid_c1", "detail_1");
        this.insertUser("2", "uid_d", "detail_1");
        this.emitsNothing();
        this.insertOrder("2", "oid_e1", "detail_1");
        this.emits(INSERT, "2", "uid_d", "detail_1", "2", "oid_e1", "detail_1");
        this.updateBeforeUser("1", "uid_a", "detail_1");
        this.emits(UPDATE_BEFORE, this.r("1", "uid_a", "detail_1", "1", "oid_c1", "detail_1"));
        this.updateAfterUser("1", "uid_a", "detail_UPDATED");
        this.emitsNothing();
        this.updateBeforeOrder("1", "oid_c1", "detail_1");
        this.emitsNothing();
        this.updateAfterOrder("1", "oid_c1", "detail_UPDATED");
        this.emits(UPDATE_AFTER, this.r("1", "uid_a", "detail_UPDATED", "1", "oid_c1", "detail_UPDATED"));
        this.deleteUser("2", "uid_d", "detail_1");
        this.emits(DELETE, this.r("2", "uid_d", "detail_1", "2", "oid_e1", "detail_1"));
        this.deleteOrder("1", "oid_c1", "detail_UPDATED");
        this.emits(DELETE, this.r("1", "uid_a", "detail_UPDATED", "1", "oid_c1", "detail_UPDATED"));
    }

    private static GeneratedJoinCondition createCustomIndexJoinCondition(final int keyIndex, final int keyIndexToCompare) {
        return new GeneratedJoinCondition("1", "", new Object[0]){

            public JoinCondition newInstance(ClassLoader classLoader) {
                return new StreamingMultiJoinOperatorTestBase.SpecificInputsEquiKeyCondition(keyIndex, keyIndexToCompare);
            }
        };
    }

    static {
        customAttributeMap.put(1, Arrays.asList(new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 0, 1, 0), new AttributeBasedJoinKeyExtractor.ConditionAttributeRef(0, 2, 1, 2)));
    }
}

