/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.bundle.KeyedMapBundleOperator;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.bundle.trigger.BundleTrigger;
import org.apache.flink.table.runtime.operators.bundle.trigger.CountBundleTrigger;
import org.apache.flink.table.runtime.operators.deduplicate.RowTimeDeduplicateFunctionTestBase;
import org.apache.flink.table.runtime.operators.deduplicate.RowTimeMiniBatchLatestChangeDeduplicateFunction;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RowTimeMiniBatchLatestChangeDeduplicateFunctionTest
extends RowTimeDeduplicateFunctionTestBase {
    RowTimeMiniBatchLatestChangeDeduplicateFunctionTest() {
    }

    @Test
    void testKeepLastRowWithoutGenerateUpdateBeforeAndWithGenerateInsert() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(false, true, true);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 11, 2L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 14, 3L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testKeepLastRowWithoutGenerateUpdateBeforeAndWithoutGenerateInsert() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(false, false, true);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 11, 2L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 14, 3L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testKeepLastRowWithGenerateUpdateBeforeAndWithGenerateInsert() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(true, true, true);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 11, 2L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 11, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 14, 3L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testKeepLastRowWithGenerateUpdateBeforeAndWithoutGenerateInsert() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(true, false, true);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 11, 2L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 11, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 14, 3L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testKeepLastRowWithGenerateUpdateBeforeAndWithGenerateInsertAndStateTtl() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(true, true, true);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 11, 2L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.setStateTtlProcessingTime(10L);
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 14, 3L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testKeepFirstRowWithoutGenerateUpdateBeforeAndWithGenerateInsert() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(false, true, false);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 10, 1L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testKeepFirstRowWithoutGenerateUpdateBeforeAndWithoutGenerateInsert() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(false, false, false);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 10, 1L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testKeepFirstRowWithGenerateUpdateBeforeAndWithGenerateInsert() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(true, true, false);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 10, 1L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testKeepFirstRowWithGenerateUpdateBeforeAndWithoutGenerateInsert() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(true, false, false);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 10, 1L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    void testKeepFirstRowWithGenerateUpdateBeforeAndWithGenerateInsertAndStateTtl() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(true, true, false);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 10, 1L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 11, 2L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 13, 1L));
        Assertions.assertThat((Collection)testHarness.getOutput()).isEmpty();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 12, 1L));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 10, 1L));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.setStateTtlProcessingTime(10L);
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 14, 3L));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 15, 1L));
        testHarness.processWatermark(new Watermark(3L));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 15, 1L));
        expectedOutput.add(new Watermark(3L));
        testHarness.close();
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    private OneInputStreamOperatorTestHarness<RowData, RowData> createTestHarness(boolean generateUpdateBefore, boolean generateInsert, boolean keepLastRow) throws Exception {
        RowTimeMiniBatchLatestChangeDeduplicateFunction func = new RowTimeMiniBatchLatestChangeDeduplicateFunction(this.inputRowType, this.serializer, this.minTtlTime.toMillis(), this.rowTimeIndex, generateUpdateBefore, generateInsert, keepLastRow);
        CountBundleTrigger trigger = new CountBundleTrigger(4L);
        KeyedMapBundleOperator keyedMapBundleOperator = new KeyedMapBundleOperator((MapBundleFunction)func, (BundleTrigger)trigger);
        return this.createTestHarness((OneInputStreamOperator<RowData, RowData>)keyedMapBundleOperator);
    }
}

