/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.util;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;

public class DataFormatTestUtil {
    public static String rowDataToString(RowData row, RowType type) {
        Preconditions.checkArgument((type.getFieldCount() == row.getArity() ? 1 : 0) != 0);
        StringBuilder build = new StringBuilder();
        build.append(row.getRowKind().shortString()).append("(");
        for (int i = 0; i < row.getArity(); ++i) {
            build.append(',');
            if (row.isNullAt(i)) {
                build.append("null");
                continue;
            }
            RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)type.getTypeAt(i), (int)i);
            build.append(fieldGetter.getFieldOrNull(row));
        }
        build.append(')');
        return build.toString();
    }

    public static BinaryRowData get24BytesBinaryRow() {
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, StringData.fromString((String)RandomStringUtils.randomNumeric((int)2)));
        writer.writeString(1, StringData.fromString((String)RandomStringUtils.randomNumeric((int)2)));
        writer.complete();
        return row;
    }

    public static BinaryRowData get160BytesBinaryRow() {
        BinaryRowData row = new BinaryRowData(2);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, StringData.fromString((String)RandomStringUtils.randomNumeric((int)72)));
        writer.writeString(1, StringData.fromString((String)RandomStringUtils.randomNumeric((int)64)));
        writer.complete();
        return row;
    }

    public static BinaryRowData getMultiSeg160BytesBinaryRow(BinaryRowData row160) {
        int baseOffset;
        BinaryRowData multiSegRow160 = new BinaryRowData(2);
        MemorySegment[] segments = new MemorySegment[6];
        int posInSeg = baseOffset = 8;
        int remainSize = 160;
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = MemorySegmentFactory.wrap((byte[])new byte[32]);
            int copy = Math.min(32 - posInSeg, remainSize);
            row160.getSegments()[0].copyTo(160 - remainSize, segments[i], posInSeg, copy);
            remainSize -= copy;
            posInSeg = 0;
        }
        multiSegRow160.pointTo(segments, baseOffset, 160);
        Assertions.assertThat((Object)multiSegRow160).isEqualTo((Object)row160);
        return multiSegRow160;
    }

    public static BinaryRowData getMultiSeg160BytesInOneSegRow(BinaryRowData row160) {
        MemorySegment[] segments = new MemorySegment[]{row160.getSegments()[0], MemorySegmentFactory.wrap((byte[])new byte[row160.getSegments()[0].size()])};
        row160.pointTo(segments, 0, row160.getSizeInBytes());
        return row160;
    }

    public static MemorySegment[] splitBytes(byte[] bytes, int baseOffset) {
        int newSize = (bytes.length + 1) / 2 + baseOffset;
        MemorySegment[] ret = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[newSize]), MemorySegmentFactory.wrap((byte[])new byte[newSize])};
        ret[0].put(baseOffset, bytes, 0, newSize - baseOffset);
        ret[1].put(0, bytes, newSize - baseOffset, bytes.length - (newSize - baseOffset));
        return ret;
    }

    public static class MyObj {
        public int i;
        public double j;

        public MyObj(int i, double j) {
            this.i = i;
            this.j = j;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyObj myObj = (MyObj)o;
            return this.i == myObj.i && Double.compare(myObj.j, this.j) == 0;
        }

        public String toString() {
            return "MyObj{i=" + this.i + ", j=" + this.j + "}";
        }
    }
}

