/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
class CurrentWatermarkInputTypeStrategy
implements InputTypeStrategy {
    CurrentWatermarkInputTypeStrategy() {
    }

    @Override
    public ArgumentCount getArgumentCount() {
        return ConstantArgumentCount.of(1);
    }

    @Override
    public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes == null || argumentDataTypes.isEmpty()) {
            return Optional.of(Collections.emptyList());
        }
        DataType dataType = argumentDataTypes.get(0);
        if (!LogicalTypeChecks.canBeTimeAttributeType(dataType.getLogicalType())) {
            return callContext.fail(throwOnFailure, "CURRENT_WATERMARK() must be called with a single rowtime attribute argument, but '%s' cannot be a time attribute.", dataType.getLogicalType().asSummaryString());
        }
        if (!LogicalTypeChecks.isRowtimeAttribute(dataType.getLogicalType())) {
            return callContext.fail(throwOnFailure, "The argument of CURRENT_WATERMARK() must be a rowtime attribute, but was '%s'.", dataType.getLogicalType().asSummaryString());
        }
        return Optional.of(Collections.singletonList(dataType));
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        ArrayList<Signature> signatures = new ArrayList<Signature>();
        signatures.add(CurrentWatermarkInputTypeStrategy.createExpectedSignature(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE));
        signatures.add(CurrentWatermarkInputTypeStrategy.createExpectedSignature(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE));
        return signatures;
    }

    private static Signature createExpectedSignature(LogicalTypeRoot typeRoot) {
        String argument = String.format("<%s *%s*>", new Object[]{typeRoot, TimestampKind.ROWTIME});
        return Signature.of(Signature.Argument.of(argument));
    }
}

