/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.factories.NoMatchingTableFactoryException;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.factories.TestTableSinkFactory;
import org.apache.flink.table.legacy.factories.TableSinkFactory;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TableSinkFactoryServiceTest {
    TableSinkFactoryServiceTest() {
    }

    @Test
    void testValidProperties() {
        Map<String, String> props = this.properties();
        Assertions.assertThat((Object)((TableSinkFactory)TableFactoryService.find(TableSinkFactory.class, props))).isInstanceOf(TestTableSinkFactory.class);
    }

    @Test
    void testInvalidContext() {
        Map<String, String> props = this.properties();
        props.put("connector.type", "unknown-connector-type");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableFactoryService.find(TableSinkFactory.class, (Map)props)).isInstanceOf(NoMatchingTableFactoryException.class)).hasMessageContaining("Could not find a suitable table factory");
    }

    @Test
    void testDifferentContextVersion() {
        Map<String, String> props = this.properties();
        props.put("connector.property-version", "2");
        Assertions.assertThat((Object)((TableSinkFactory)TableFactoryService.find(TableSinkFactory.class, props))).isInstanceOf(TestTableSinkFactory.class);
    }

    @Test
    void testUnsupportedProperty() {
        Map<String, String> props = this.properties();
        props.put("format.path_new", "/new/path");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableFactoryService.find(TableSinkFactory.class, (Map)props)).isInstanceOf(NoMatchingTableFactoryException.class)).hasMessageContaining("The matching candidates:\norg.apache.flink.table.factories.TestTableSinkFactory\nUnsupported property keys:\nformat.path_new");
    }

    @Test
    void testMissingProperty() {
        Map<String, String> props = this.properties();
        props.remove("format.type");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableFactoryService.find(TableSinkFactory.class, (Map)props)).isInstanceOf(NoMatchingTableFactoryException.class)).hasMessageContaining("The matching candidates:\norg.apache.flink.table.factories.TestTableSinkFactory\nMissing properties:\nformat.type=test");
    }

    @Test
    void testMismatchedProperty() {
        Map<String, String> props = this.properties();
        props.put("format.type", "test_new");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableFactoryService.find(TableSinkFactory.class, (Map)props)).isInstanceOf(NoMatchingTableFactoryException.class)).hasMessageContaining("The matching candidates:\norg.apache.flink.table.factories.TestTableSinkFactory\nMismatched properties:\n'format.type' expects 'test', but is 'test_new'");
    }

    @Test
    void testMissingAndMismatchedProperty() {
        Map<String, String> props = this.properties();
        props.put("format.type", "test_new");
        props.remove("required.test");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableFactoryService.find(TableSinkFactory.class, (Map)props)).isInstanceOf(NoMatchingTableFactoryException.class)).hasMessageContaining("The matching candidates:\norg.apache.flink.table.factories.TestTableSinkFactory\nMissing properties:\nrequired.test=required-0\nMismatched properties:\n'format.type' expects 'test', but is 'test_new'");
    }

    private Map<String, String> properties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connector.type", "test");
        properties.put("format.type", "test");
        properties.put("required.test", "required-0");
        properties.put("connector.property-version", "1");
        properties.put("format.property-version", "1");
        properties.put("format.path", "/path/to/target");
        properties.put("schema.0.name", "a");
        properties.put("schema.1.name", "b");
        properties.put("schema.2.name", "c");
        properties.put("schema.0.field.0.name", "a");
        properties.put("schema.0.field.1.name", "b");
        properties.put("schema.0.field.2.name", "c");
        return properties;
    }
}

