/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;

@Internal
public final class ItemAtIndexArgumentTypeStrategy
implements ArgumentTypeStrategy {
    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType collectionType = argumentDataTypes.get(0).getLogicalType();
        DataType indexType = argumentDataTypes.get(1);
        if (collectionType.is(LogicalTypeRoot.ARRAY)) {
            if (indexType.getLogicalType().is(LogicalTypeFamily.INTEGER_NUMERIC)) {
                Optional<Integer> literalVal;
                if (callContext.isArgumentLiteral(1) && (literalVal = callContext.getArgumentValue(1, Integer.class)).isPresent() && literalVal.get() <= 0) {
                    return callContext.fail(throwOnFailure, "The provided index must be a valid SQL index starting from 1, but was '%s'", literalVal.get());
                }
                return Optional.of(indexType);
            }
            return callContext.fail(throwOnFailure, "Array can be indexed only using an INTEGER NUMERIC type.", new Object[0]);
        }
        if (collectionType.is(LogicalTypeRoot.MAP)) {
            MapType mapType = (MapType)collectionType;
            if (LogicalTypeCasts.supportsImplicitCast(indexType.getLogicalType(), mapType.getKeyType())) {
                KeyValueDataType mapDataType = (KeyValueDataType)argumentDataTypes.get(0);
                return Optional.of(mapDataType.getKeyDataType());
            }
            return callContext.fail(throwOnFailure, "Expected index for a MAP to be of type: %s", mapType.getKeyType());
        }
        return Optional.empty();
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of("[<INTEGER NUMERIC> | <MAP_KEY_TYPE>]");
    }
}

