/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.JsonExistsOnError;
import org.apache.flink.table.api.JsonOnNull;
import org.apache.flink.table.api.JsonQueryOnEmptyOrError;
import org.apache.flink.table.api.JsonQueryWrapper;
import org.apache.flink.table.api.JsonType;
import org.apache.flink.table.api.JsonValueOnEmptyOrError;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.CallSyntaxUtils;
import org.apache.flink.table.functions.SqlCallSyntax;

@Internal
class JsonFunctionsCallSyntax {
    static final SqlCallSyntax IS_JSON = (sqlName, operands, sqlFactory) -> {
        String s = String.format("%s IS JSON", CallSyntaxUtils.asSerializableOperand((ResolvedExpression)operands.get(0), sqlFactory));
        if (operands.size() > 1) {
            return s + " " + CallSyntaxUtils.getSymbolLiteral((ResolvedExpression)operands.get(1), JsonType.class);
        }
        return s;
    };
    static final SqlCallSyntax JSON_VALUE = (sqlName, operands, sqlFactory) -> {
        StringBuilder s = new StringBuilder(String.format("JSON_VALUE(%s, %s RETURNING %s ", ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(1)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(2)).asSerializableString(sqlFactory)));
        JsonValueOnEmptyOrError onEmpty = CallSyntaxUtils.getSymbolLiteral((ResolvedExpression)operands.get(3), JsonValueOnEmptyOrError.class);
        if (onEmpty == JsonValueOnEmptyOrError.DEFAULT) {
            s.append(String.format("DEFAULT %s", ((ResolvedExpression)operands.get(4)).asSerializableString(sqlFactory)));
        } else {
            s.append(onEmpty);
        }
        s.append(" ON EMPTY ");
        JsonValueOnEmptyOrError onError = CallSyntaxUtils.getSymbolLiteral((ResolvedExpression)operands.get(5), JsonValueOnEmptyOrError.class);
        if (onError == JsonValueOnEmptyOrError.DEFAULT) {
            s.append(String.format("DEFAULT %s", ((ResolvedExpression)operands.get(6)).asSerializableString(sqlFactory)));
        } else {
            s.append(onError);
        }
        s.append(" ON ERROR)");
        return s.toString();
    };
    static final SqlCallSyntax JSON_EXISTS = (sqlName, operands, sqlFactory) -> {
        if (operands.size() == 3) {
            return String.format("%s(%s, %s %s ON ERROR)", sqlName, ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(1)).asSerializableString(sqlFactory), CallSyntaxUtils.getSymbolLiteral((ResolvedExpression)operands.get(2), JsonExistsOnError.class));
        }
        return SqlCallSyntax.FUNCTION.unparse(sqlName, operands, sqlFactory);
    };
    static final SqlCallSyntax JSON_QUERY = (sqlName, operands, sqlFactory) -> {
        JsonQueryWrapper wrapper = CallSyntaxUtils.getSymbolLiteral((ResolvedExpression)operands.get(3), JsonQueryWrapper.class);
        JsonQueryOnEmptyOrError onEmpty = CallSyntaxUtils.getSymbolLiteral((ResolvedExpression)operands.get(4), JsonQueryOnEmptyOrError.class);
        JsonQueryOnEmptyOrError onError = CallSyntaxUtils.getSymbolLiteral((ResolvedExpression)operands.get(5), JsonQueryOnEmptyOrError.class);
        return String.format("JSON_QUERY(%s, %s RETURNING %s %s WRAPPER %s ON EMPTY %s ON ERROR)", ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(1)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(2)).asSerializableString(sqlFactory), JsonFunctionsCallSyntax.toString(wrapper), onEmpty.toString().replaceAll("_", " "), onError.toString().replaceAll("_", " "));
    };
    static final SqlCallSyntax JSON_OBJECT = (sqlName, operands, sqlFactory) -> {
        String entries = IntStream.range(0, operands.size() / 2).mapToObj(i -> String.format("KEY %s VALUE %s", ((ResolvedExpression)operands.get(2 * i + 1)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(2 * i + 2)).asSerializableString(sqlFactory))).collect(Collectors.joining(", "));
        JsonOnNull onNull = CallSyntaxUtils.getSymbolLiteral((ResolvedExpression)operands.get(0), JsonOnNull.class);
        return String.format("JSON_OBJECT(%s %s ON NULL)", entries, onNull);
    };
    static final SqlCallSyntax JSON_ARRAY = (sqlName, operands, sqlFactory) -> {
        if (operands.size() == 1) {
            return "JSON_ARRAY()";
        }
        String entries = operands.subList(1, operands.size()).stream().map(resolvedExpression -> resolvedExpression.asSerializableString(sqlFactory)).collect(Collectors.joining(", "));
        JsonOnNull onNull = CallSyntaxUtils.getSymbolLiteral((ResolvedExpression)operands.get(0), JsonOnNull.class);
        return String.format("JSON_ARRAY(%s %s ON NULL)", entries, onNull);
    };

    static SqlCallSyntax jsonArrayAgg(JsonOnNull onNull) {
        return (sqlName, operands, sqlFactory) -> String.format("%s(%s %s ON NULL)", sqlName, ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), onNull);
    }

    static SqlCallSyntax jsonObjectAgg(JsonOnNull onNull) {
        return (sqlName, operands, sqlFactory) -> String.format("%s(KEY %s VALUE %s %s ON NULL)", sqlName, ((ResolvedExpression)operands.get(0)).asSerializableString(sqlFactory), ((ResolvedExpression)operands.get(1)).asSerializableString(sqlFactory), onNull);
    }

    private static String toString(JsonQueryWrapper wrapper) {
        String wrapperStr;
        switch (wrapper) {
            case WITHOUT_ARRAY: {
                wrapperStr = "WITHOUT ARRAY";
                break;
            }
            case CONDITIONAL_ARRAY: {
                wrapperStr = "WITH CONDITIONAL ARRAY";
                break;
            }
            case UNCONDITIONAL_ARRAY: {
                wrapperStr = "WITH UNCONDITIONAL ARRAY";
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + wrapper);
            }
        }
        return wrapperStr;
    }

    private JsonFunctionsCallSyntax() {
    }
}

