/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.LegacyTypeInfoDataTypeConverter;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class LegacyTypeInfoDataTypeConverterTest {
    LegacyTypeInfoDataTypeConverterTest() {
    }

    private static Stream<Arguments> typeInfo() {
        return Stream.of(Arguments.of((Object[])new Object[]{Types.STRING, DataTypes.STRING()}), Arguments.of((Object[])new Object[]{Types.STRING, DataTypes.STRING().notNull()}), Arguments.of((Object[])new Object[]{Types.BOOLEAN, DataTypes.BOOLEAN()}), Arguments.of((Object[])new Object[]{Types.SQL_TIMESTAMP, DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class)}), Arguments.of((Object[])new Object[]{Types.GENERIC(LegacyTypeInfoDataTypeConverterTest.class), new AtomicDataType((LogicalType)new LegacyTypeInformationType(LogicalTypeRoot.RAW, Types.GENERIC(LegacyTypeInfoDataTypeConverterTest.class)))}), Arguments.of((Object[])new Object[]{Types.ROW_NAMED((String[])new String[]{"field1", "field2"}, (TypeInformation[])new TypeInformation[]{Types.INT, Types.LONG}), DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field1", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"field2", (DataType)DataTypes.BIGINT())})}), Arguments.of((Object[])new Object[]{Types.MAP((TypeInformation)Types.FLOAT, (TypeInformation)Types.ROW((TypeInformation[])new TypeInformation[]{Types.BYTE})), DataTypes.MAP((DataType)DataTypes.FLOAT(), (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.TINYINT())}))}), Arguments.of((Object[])new Object[]{Types.PRIMITIVE_ARRAY((TypeInformation)Types.FLOAT), DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.FLOAT().notNull()).bridgedTo(Float.TYPE))).bridgedTo(float[].class)}), Arguments.of((Object[])new Object[]{Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE), DataTypes.BYTES()}), Arguments.of((Object[])new Object[]{Types.OBJECT_ARRAY((TypeInformation)Types.PRIMITIVE_ARRAY((TypeInformation)Types.FLOAT)), DataTypes.ARRAY((DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.FLOAT().notNull()).bridgedTo(Float.TYPE))).bridgedTo(float[].class))).bridgedTo(float[][].class)}), Arguments.of((Object[])new Object[]{BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO, new AtomicDataType((LogicalType)new LegacyTypeInformationType(LogicalTypeRoot.ARRAY, (TypeInformation)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO))}), Arguments.of((Object[])new Object[]{ObjectArrayTypeInfo.getInfoFor((TypeInformation)Types.STRING), DataTypes.ARRAY((DataType)DataTypes.STRING()).bridgedTo(String[].class)}), Arguments.of((Object[])new Object[]{Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.SHORT, Types.DOUBLE, Types.FLOAT}), new AtomicDataType((LogicalType)new LegacyTypeInformationType(LogicalTypeRoot.STRUCTURED_TYPE, Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.SHORT, Types.DOUBLE, Types.FLOAT})))}), Arguments.of((Object[])new Object[]{TimeIndicatorTypeInfo.ROWTIME_INDICATOR, new AtomicDataType((LogicalType)new TimestampType(true, TimestampKind.ROWTIME, 3)).bridgedTo(Timestamp.class)}), Arguments.of((Object[])new Object[]{TimeIndicatorTypeInfo.PROCTIME_INDICATOR, new AtomicDataType((LogicalType)new LocalZonedTimestampType(true, TimestampKind.PROCTIME, 3)).bridgedTo(Instant.class)}));
    }

    @ParameterizedTest(name="[{index}] type info: {0} data type: {1}")
    @MethodSource(value={"typeInfo"})
    void testTypeInfoToDataTypeConversion(TypeInformation<?> inputTypeInfo, DataType dataType) {
        Assertions.assertThat((Object)LegacyTypeInfoDataTypeConverter.toDataType(inputTypeInfo)).isEqualTo((Object)dataType.nullable());
    }

    @ParameterizedTest(name="[{index}] type info: {0} data type: {1}")
    @MethodSource(value={"typeInfo"})
    void testDataTypeToTypeInfoConversion(TypeInformation<?> inputTypeInfo, DataType dataType) {
        Assertions.assertThat((Object)LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo((DataType)dataType)).isEqualTo(inputTypeInfo);
    }
}

