/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.watermark;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.watermark.WatermarkEmitStrategy;
import org.apache.flink.util.StringUtils;

@Internal
public class WatermarkParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WatermarkEmitStrategy emitStrategy;
    private String alignGroupName;
    private Duration alignMaxDrift;
    private Duration alignUpdateInterval;
    private long sourceIdleTimeout;

    public WatermarkParams() {
    }

    public WatermarkParams(WatermarkEmitStrategy emitStrategy, String alignGroupName, Duration alignMaxDrift, Duration alignUpdateInterval, long sourceIdleTimeout) {
        this.emitStrategy = emitStrategy;
        this.alignGroupName = alignGroupName;
        this.alignMaxDrift = alignMaxDrift;
        this.alignUpdateInterval = alignUpdateInterval;
        this.sourceIdleTimeout = sourceIdleTimeout;
    }

    public WatermarkEmitStrategy getEmitStrategy() {
        return this.emitStrategy;
    }

    public void setEmitStrategy(WatermarkEmitStrategy emitStrategy) {
        this.emitStrategy = emitStrategy;
    }

    public String getAlignGroupName() {
        return this.alignGroupName;
    }

    public void setAlignGroupName(String alignGroupName) {
        this.alignGroupName = alignGroupName;
    }

    public Duration getAlignMaxDrift() {
        return this.alignMaxDrift;
    }

    public void setAlignMaxDrift(Duration alignMaxDrift) {
        this.alignMaxDrift = alignMaxDrift;
    }

    public Duration getAlignUpdateInterval() {
        return this.alignUpdateInterval;
    }

    public void setAlignUpdateInterval(Duration alignUpdateInterval) {
        this.alignUpdateInterval = alignUpdateInterval;
    }

    public long getSourceIdleTimeout() {
        return this.sourceIdleTimeout;
    }

    public void setSourceIdleTimeout(long sourceIdleTimeout) {
        this.sourceIdleTimeout = sourceIdleTimeout;
    }

    public boolean alignWatermarkEnabled() {
        return !StringUtils.isNullOrWhitespaceOnly((String)this.alignGroupName) && this.isLegalDuration(this.alignMaxDrift) && this.isLegalDuration(this.alignUpdateInterval);
    }

    private boolean isLegalDuration(Duration duration) {
        return duration != null && !duration.isNegative() && !duration.isZero();
    }

    public static WatermarkParamsBuilder builder() {
        return new WatermarkParamsBuilder();
    }

    public String toString() {
        return "WatermarkParams{emitStrategy=" + this.emitStrategy + ", alignGroupName='" + this.alignGroupName + "', alignMaxDrift=" + this.alignMaxDrift + ", alignUpdateInterval=" + this.alignUpdateInterval + ", sourceIdleTimeout=" + this.sourceIdleTimeout + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatermarkParams that = (WatermarkParams)o;
        return this.sourceIdleTimeout == that.sourceIdleTimeout && this.emitStrategy == that.emitStrategy && Objects.equals(this.alignGroupName, that.alignGroupName) && Objects.equals(this.alignMaxDrift, that.alignMaxDrift) && Objects.equals(this.alignUpdateInterval, that.alignUpdateInterval);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.emitStrategy, this.alignGroupName, this.alignMaxDrift, this.alignUpdateInterval, this.sourceIdleTimeout});
    }

    @Internal
    public static class WatermarkParamsBuilder {
        private WatermarkEmitStrategy emitStrategy = (WatermarkEmitStrategy)((Object)FactoryUtil.WATERMARK_EMIT_STRATEGY.defaultValue());
        private String alignGroupName;
        private Duration alignMaxDrift = Duration.ZERO;
        private Duration alignUpdateInterval = (Duration)FactoryUtil.WATERMARK_ALIGNMENT_UPDATE_INTERVAL.defaultValue();
        private long sourceIdleTimeout = -1L;

        public WatermarkParamsBuilder emitStrategy(WatermarkEmitStrategy emitStrategy) {
            this.emitStrategy = emitStrategy;
            return this;
        }

        public WatermarkParamsBuilder alignGroupName(String alignGroupName) {
            this.alignGroupName = alignGroupName;
            return this;
        }

        public WatermarkParamsBuilder alignMaxDrift(Duration alignMaxDrift) {
            this.alignMaxDrift = alignMaxDrift;
            return this;
        }

        public WatermarkParamsBuilder alignUpdateInterval(Duration alignUpdateInterval) {
            this.alignUpdateInterval = alignUpdateInterval;
            return this;
        }

        public WatermarkParamsBuilder sourceIdleTimeout(long sourceIdleTimeout) {
            this.sourceIdleTimeout = sourceIdleTimeout;
            return this;
        }

        public WatermarkParams build() {
            return new WatermarkParams(this.emitStrategy, this.alignGroupName, this.alignMaxDrift, this.alignUpdateInterval, this.sourceIdleTimeout);
        }
    }
}

