/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.columnar.vector.heap;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.columnar.ColumnarRowData;
import org.apache.flink.table.data.columnar.vector.RowColumnVector;
import org.apache.flink.table.data.columnar.vector.VectorizedColumnBatch;
import org.apache.flink.table.data.columnar.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;

@Internal
public class HeapRowVector
extends AbstractHeapVector
implements WritableColumnVector,
RowColumnVector {
    private WritableColumnVector[] fields;

    public HeapRowVector(int len, WritableColumnVector ... fields) {
        super(len);
        this.fields = fields;
    }

    public WritableColumnVector[] getFields() {
        return this.fields;
    }

    public void setFields(WritableColumnVector[] fields) {
        this.fields = fields;
    }

    @Override
    public ColumnarRowData getRow(int i) {
        ColumnarRowData columnarRowData = new ColumnarRowData(new VectorizedColumnBatch(this.fields));
        columnarRowData.setRowId(i);
        return columnarRowData;
    }

    @Override
    public void reset() {
        super.reset();
        for (WritableColumnVector field : this.fields) {
            field.reset();
        }
    }
}

