/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import java.math.BigDecimal;
import java.sql.Time;
import java.time.Duration;
import java.time.Period;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.utils.ClassDataTypeConverter;
import org.apache.flink.types.Row;
import org.apache.flink.types.variant.BinaryVariant;
import org.apache.flink.types.variant.Variant;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ClassDataTypeConverterTest {
    ClassDataTypeConverterTest() {
    }

    private static Stream<Arguments> testData() {
        return Stream.of(Arguments.of((Object[])new Object[]{Long.TYPE, ((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)}), Arguments.of((Object[])new Object[]{byte[].class, ((DataType)DataTypes.BYTES().nullable()).bridgedTo(byte[].class)}), Arguments.of((Object[])new Object[]{Long.class, ((DataType)DataTypes.BIGINT().nullable()).bridgedTo(Long.class)}), Arguments.of((Object[])new Object[]{Time.class, ((DataType)DataTypes.TIME((int)0).nullable()).bridgedTo(Time.class)}), Arguments.of((Object[])new Object[]{Duration.class, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND((int)9)).bridgedTo(Duration.class)}), Arguments.of((Object[])new Object[]{Period.class, DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.YEAR((int)4), (DataTypes.Resolution)DataTypes.MONTH()).bridgedTo(Period.class)}), Arguments.of((Object[])new Object[]{BigDecimal.class, null}), Arguments.of((Object[])new Object[]{byte[][].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.BYTES().nullable()).bridgedTo(byte[].class))).nullable()).bridgedTo(byte[][].class)}), Arguments.of((Object[])new Object[]{Byte[].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.TINYINT().nullable()).bridgedTo(Byte.class))).nullable()).bridgedTo(Byte[].class)}), Arguments.of((Object[])new Object[]{Byte[][].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.TINYINT().nullable()).bridgedTo(Byte.class))).nullable()).bridgedTo(Byte[].class))).nullable()).bridgedTo(Byte[][].class)}), Arguments.of((Object[])new Object[]{Integer[].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.INT().nullable()).bridgedTo(Integer.class))).nullable()).bridgedTo(Integer[].class)}), Arguments.of((Object[])new Object[]{int[].class, ((DataType)DataTypes.ARRAY((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))).nullable()).bridgedTo(int[].class)}), Arguments.of((Object[])new Object[]{TimeIntervalUnit.class, new AtomicDataType((LogicalType)new SymbolType()).bridgedTo(TimeIntervalUnit.class)}), Arguments.of((Object[])new Object[]{Row.class, null}), Arguments.of((Object[])new Object[]{Variant.class, DataTypes.VARIANT()}), Arguments.of((Object[])new Object[]{BinaryVariant.class, DataTypes.VARIANT().bridgedTo(BinaryVariant.class)}));
    }

    @ParameterizedTest(name="[{index}] class: {0} type: {1}")
    @MethodSource(value={"testData"})
    void testClassToDataTypeConversion(Class<?> clazz, @Nullable DataType dataType) {
        if (dataType == null) {
            Assertions.assertThat((Optional)ClassDataTypeConverter.extractDataType(clazz)).isEmpty();
        } else {
            Assertions.assertThat((Optional)ClassDataTypeConverter.extractDataType(clazz)).contains((Object)dataType);
        }
    }
}

