/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.utils;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.test.TableAssertions;
import org.apache.flink.types.RowKind;
import org.junit.jupiter.api.Test;

class JoinedRowDataTest {
    JoinedRowDataTest() {
    }

    @Test
    void testJoinedRows() {
        GenericRowData row1 = GenericRowData.of((Object[])new Object[]{1L, 2L});
        GenericRowData row2 = GenericRowData.of((Object[])new Object[]{3L, StringData.fromString((String)"4")});
        JoinedRowData joinedRow = new JoinedRowData((RowData)row1, (RowData)row2);
        TableAssertions.assertThat((RowData)joinedRow).hasKind(RowKind.INSERT).hasArity(4);
        TableAssertions.assertThat((RowData)joinedRow).getLong(0).isEqualTo(1L);
        TableAssertions.assertThat((RowData)joinedRow).getLong(1).isEqualTo(2L);
        TableAssertions.assertThat((RowData)joinedRow).getLong(2).isEqualTo(3L);
        TableAssertions.assertThat((RowData)joinedRow).getString(3).isEqualTo("4");
    }

    @Test
    void testJoinedRowKind() {
        JoinedRowData joinedRow = new JoinedRowData(RowKind.DELETE, (RowData)GenericRowData.of((Object[])new Object[0]), (RowData)GenericRowData.of((Object[])new Object[0]));
        TableAssertions.assertThat((RowData)joinedRow).hasKind(RowKind.DELETE);
    }

    @Test
    void testReplace() {
        GenericRowData row1 = GenericRowData.of((Object[])new Object[]{1L});
        GenericRowData row2 = GenericRowData.of((Object[])new Object[]{2L});
        JoinedRowData joinedRow = new JoinedRowData((RowData)row1, (RowData)row2);
        TableAssertions.assertThat((RowData)joinedRow).hasArity(2);
        joinedRow.replace((RowData)GenericRowData.of((Object[])new Object[]{3L}), (RowData)GenericRowData.of((Object[])new Object[]{4L, 5L}));
        TableAssertions.assertThat((RowData)joinedRow).hasArity(3);
        TableAssertions.assertThat((RowData)joinedRow).getLong(0).isEqualTo(3L);
        TableAssertions.assertThat((RowData)joinedRow).getLong(1).isEqualTo(4L);
        TableAssertions.assertThat((RowData)joinedRow).getLong(2).isEqualTo(5L);
    }
}

