/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.columnar;

import org.apache.flink.table.data.columnar.ColumnarArrayData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapBytesVector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class ColumnarArrayDataTest {
    ColumnarArrayDataTest() {
    }

    @Test
    @DisplayName(value="getBinary() should work correctly for slices with position 0")
    void testGetBinaryWhenOffsetIsZero() {
        HeapBytesVector vector = new HeapBytesVector(2);
        byte[] sourceData = new byte[]{10, 20, 30, 40, 50};
        vector.appendBytes(0, sourceData, 0, 3);
        ColumnarArrayData arrayData = new ColumnarArrayData((ColumnVector)vector, 0, 1);
        byte[] actual = arrayData.getBinary(0);
        byte[] expected = new byte[]{10, 20, 30};
        Assertions.assertThat((byte[])actual).isEqualTo((Object)expected);
    }

    @Test
    @DisplayName(value="getBinary() should return correct sub-array when slice position is non-zero")
    void testGetBinaryWhenPositionNonZero() {
        HeapBytesVector vector = new HeapBytesVector(3);
        byte[] dummyData = new byte[]{99, 99, 99, 99};
        vector.appendBytes(0, dummyData, 0, 4);
        byte[] sourceData1 = new byte[]{30, 40, 50, 60};
        vector.appendBytes(1, sourceData1, 0, 4);
        byte[] sourceData2 = new byte[]{70, 80, 90, 100};
        vector.appendBytes(2, sourceData2, 0, 4);
        ColumnarArrayData arrayData = new ColumnarArrayData((ColumnVector)vector, 0, 1);
        Assertions.assertThat((byte[])arrayData.getBinary(0)).isEqualTo((Object)dummyData);
        Assertions.assertThat((byte[])arrayData.getBinary(1)).isEqualTo((Object)sourceData1);
        Assertions.assertThat((byte[])arrayData.getBinary(2)).isEqualTo((Object)sourceData2);
    }
}

