/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@Internal
public final class CommonTypeStrategy
implements TypeStrategy {
    private final ArgumentCount argumentRange;

    public CommonTypeStrategy() {
        this.argumentRange = ConstantArgumentCount.any();
    }

    public CommonTypeStrategy(ArgumentCount argumentRange) {
        this.argumentRange = argumentRange;
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        int maxCount;
        int minCount = this.argumentRange.getMinCount().orElse(0);
        Preconditions.checkArgument((minCount <= (maxCount = this.argumentRange.getMaxCount().orElse(callContext.getArgumentDataTypes().size() - 1).intValue()) ? 1 : 0) != 0);
        List<LogicalType> selectedActualTypes = callContext.getArgumentDataTypes().subList(minCount, maxCount + 1).stream().map(DataType::getLogicalType).collect(Collectors.toList());
        return LogicalTypeMerging.findCommonType(selectedActualTypes).map(TypeConversions::fromLogicalToDataType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommonTypeStrategy)) {
            return false;
        }
        CommonTypeStrategy that = (CommonTypeStrategy)o;
        return this.argumentRange.equals(that.argumentRange);
    }

    public int hashCode() {
        return Objects.hash(this.argumentRange);
    }
}

