/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.util.Preconditions;

@Internal
public class DefaultCatalogMaterializedTable
implements CatalogMaterializedTable {
    private final Schema schema;
    @Nullable
    private final String comment;
    @Nullable
    private final TableDistribution distribution;
    private final List<String> partitionKeys;
    private final Map<String, String> options;
    @Nullable
    private final Long snapshot;
    private final String definitionQuery;
    private final IntervalFreshness freshness;
    private final CatalogMaterializedTable.LogicalRefreshMode logicalRefreshMode;
    private final CatalogMaterializedTable.RefreshMode refreshMode;
    private final CatalogMaterializedTable.RefreshStatus refreshStatus;
    @Nullable
    private final String refreshHandlerDescription;
    @Nullable
    private final byte[] serializedRefreshHandler;

    protected DefaultCatalogMaterializedTable(Schema schema, @Nullable String comment, @Nullable TableDistribution distribution, List<String> partitionKeys, Map<String, String> options, @Nullable Long snapshot, String definitionQuery, IntervalFreshness freshness, CatalogMaterializedTable.LogicalRefreshMode logicalRefreshMode, CatalogMaterializedTable.RefreshMode refreshMode, CatalogMaterializedTable.RefreshStatus refreshStatus, @Nullable String refreshHandlerDescription, @Nullable byte[] serializedRefreshHandler) {
        this.schema = (Schema)Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        this.comment = comment;
        this.distribution = distribution;
        this.partitionKeys = (List)Preconditions.checkNotNull(partitionKeys, (String)"Partition keys must not be null.");
        this.options = (Map)Preconditions.checkNotNull(options, (String)"Options must not be null.");
        this.snapshot = snapshot;
        this.definitionQuery = (String)Preconditions.checkNotNull((Object)definitionQuery, (String)"Definition query must not be null.");
        this.freshness = (IntervalFreshness)Preconditions.checkNotNull((Object)freshness, (String)"Freshness must not be null.");
        this.logicalRefreshMode = (CatalogMaterializedTable.LogicalRefreshMode)((Object)Preconditions.checkNotNull((Object)((Object)logicalRefreshMode), (String)"Logical refresh mode must not be null."));
        this.refreshMode = (CatalogMaterializedTable.RefreshMode)((Object)Preconditions.checkNotNull((Object)((Object)refreshMode), (String)"Refresh mode must not be null."));
        this.refreshStatus = (CatalogMaterializedTable.RefreshStatus)((Object)Preconditions.checkNotNull((Object)((Object)refreshStatus), (String)"Refresh status must not be null."));
        this.refreshHandlerDescription = refreshHandlerDescription;
        this.serializedRefreshHandler = serializedRefreshHandler;
        Preconditions.checkArgument((boolean)options.entrySet().stream().allMatch(e -> e.getKey() != null && e.getValue() != null), (Object)"Options cannot have null keys or values.");
    }

    @Override
    public Schema getUnresolvedSchema() {
        return this.schema;
    }

    @Override
    public String getComment() {
        return this.comment != null ? this.comment : "";
    }

    @Override
    public Optional<TableDistribution> getDistribution() {
        return Optional.ofNullable(this.distribution);
    }

    @Override
    public boolean isPartitioned() {
        return !this.partitionKeys.isEmpty();
    }

    @Override
    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public CatalogBaseTable copy() {
        return new DefaultCatalogMaterializedTable(this.schema, this.comment, this.distribution, this.partitionKeys, this.options, this.snapshot, this.definitionQuery, this.freshness, this.logicalRefreshMode, this.refreshMode, this.refreshStatus, this.refreshHandlerDescription, this.serializedRefreshHandler);
    }

    @Override
    public CatalogMaterializedTable copy(Map<String, String> options) {
        return new DefaultCatalogMaterializedTable(this.schema, this.comment, this.distribution, this.partitionKeys, options, this.snapshot, this.definitionQuery, this.freshness, this.logicalRefreshMode, this.refreshMode, this.refreshStatus, this.refreshHandlerDescription, this.serializedRefreshHandler);
    }

    @Override
    public CatalogMaterializedTable copy(CatalogMaterializedTable.RefreshStatus refreshStatus, String refreshHandlerDescription, byte[] serializedRefreshHandler) {
        return new DefaultCatalogMaterializedTable(this.schema, this.comment, this.distribution, this.partitionKeys, this.options, this.snapshot, this.definitionQuery, this.freshness, this.logicalRefreshMode, this.refreshMode, refreshStatus, refreshHandlerDescription, serializedRefreshHandler);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.of(this.getComment());
    }

    @Override
    public Optional<String> getDetailedDescription() {
        return Optional.empty();
    }

    @Override
    public Optional<Long> getSnapshot() {
        return Optional.ofNullable(this.snapshot);
    }

    @Override
    public String getDefinitionQuery() {
        return this.definitionQuery;
    }

    @Override
    public IntervalFreshness getDefinitionFreshness() {
        return this.freshness;
    }

    @Override
    public CatalogMaterializedTable.LogicalRefreshMode getLogicalRefreshMode() {
        return this.logicalRefreshMode;
    }

    @Override
    public CatalogMaterializedTable.RefreshMode getRefreshMode() {
        return this.refreshMode;
    }

    @Override
    public CatalogMaterializedTable.RefreshStatus getRefreshStatus() {
        return this.refreshStatus;
    }

    @Override
    public Optional<String> getRefreshHandlerDescription() {
        return Optional.ofNullable(this.refreshHandlerDescription);
    }

    @Override
    @Nullable
    public byte[] getSerializedRefreshHandler() {
        return this.serializedRefreshHandler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCatalogMaterializedTable that = (DefaultCatalogMaterializedTable)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.comment, that.comment) && Objects.equals(this.partitionKeys, that.partitionKeys) && Objects.equals(this.options, that.options) && Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.definitionQuery, that.definitionQuery) && Objects.equals(this.freshness, that.freshness) && this.logicalRefreshMode == that.logicalRefreshMode && this.refreshMode == that.refreshMode && this.refreshStatus == that.refreshStatus && Objects.equals(this.refreshHandlerDescription, that.refreshHandlerDescription) && Arrays.equals(this.serializedRefreshHandler, that.serializedRefreshHandler);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.schema, this.comment, this.partitionKeys, this.options, this.snapshot, this.definitionQuery, this.freshness, this.logicalRefreshMode, this.refreshMode, this.refreshStatus, this.refreshHandlerDescription});
        result = 31 * result + Arrays.hashCode(this.serializedRefreshHandler);
        return result;
    }

    public String toString() {
        return "DefaultCatalogMaterializedTable{schema=" + this.schema + ", comment='" + this.comment + "', distribution=" + this.distribution + ", partitionKeys=" + this.partitionKeys + ", options=" + this.options + ", snapshot=" + this.snapshot + ", definitionQuery='" + this.definitionQuery + "', freshness=" + this.freshness + ", logicalRefreshMode=" + this.logicalRefreshMode + ", refreshMode=" + this.refreshMode + ", refreshStatus=" + this.refreshStatus + ", refreshHandlerDescription='" + this.refreshHandlerDescription + "', serializedRefreshHandler=" + Arrays.toString(this.serializedRefreshHandler) + "}";
    }
}

