/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.ArgumentTrait;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.FunctionHints;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.annotation.ProcedureHints;
import org.apache.flink.table.annotation.StateHint;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AsyncScalarFunction;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.ProcessTableFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.TypeInferenceExtractor;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.StateTypeStrategy;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.StaticArgumentTrait;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.types.Row;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class TypeInferenceExtractorTest {
    TypeInferenceExtractorTest() {
    }

    private static Stream<TestSpec> testData() {
        return Stream.concat(TypeInferenceExtractorTest.functionSpecs(), TypeInferenceExtractorTest.procedureSpecs());
    }

    private static Stream<TestSpec> functionSpecs() {
        return Stream.of(TestSpec.forScalarFunction(FullFunctionHint.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"s", (DataType)DataTypes.STRING(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forScalarFunction(FullFunctionHints.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction(GlobalOutputFunctionHint.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.STRING()))), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(InvalidSingleOutputFunctionHint.class).expectErrorMessage("Function hints that lead to ambiguous results are not allowed."), TestSpec.forScalarFunction(SplitFullFunctionHints.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction(InvalidFullOutputFunctionHint.class).expectErrorMessage("Function hints with same input definition but different result types are not allowed."), TestSpec.forScalarFunction(InvalidFullOutputFunctionWithArgNamesHint.class).expectErrorMessage("Function hints with same input definition but different result types are not allowed."), TestSpec.forScalarFunction(IncompleteFunctionHint.class).expectErrorMessage("Data type missing for scalar argument at position 1."), TestSpec.forScalarFunction(ComplexFunctionHint.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"myInt", "myAny"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forScalarFunction(GlobalInputFunctionHints.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(ZeroArgFunction.class).expectEmptyStaticArguments().expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAsyncScalarFunction(ZeroArgFunctionAsync.class).expectEmptyStaticArguments().expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAsyncTableFunction(ZeroArgFunctionAsyncTable.class).expectEmptyStaticArguments().expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(MixedArgFunction.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"d", (DataType)DataTypes.DOUBLE(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAsyncScalarFunction(MixedArgFunctionAsync.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"d", (DataType)DataTypes.DOUBLE(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAsyncTableFunction(MixedArgFunctionAsyncTable.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"d", (DataType)DataTypes.DOUBLE(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(OverloadedFunction.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)))), TestSpec.forAsyncScalarFunction(OverloadedFunctionAsync.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forAsyncTableFunction(OverloadedFunctionAsyncTable.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(VarArgFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "more"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAsyncScalarFunction(VarArgFunctionAsync.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "more"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAsyncTableFunction(VarArgFunctionAsyncTable.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "more"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction(VarArgWithByteFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"bytes"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAsyncScalarFunction(VarArgWithByteFunctionAsync.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"bytes"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAsyncTableFunction(VarArgWithByteFunctionAsyncTable.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"bytes"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction(ExtractWithOutputHintFunction.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAsyncScalarFunction(ExtractWithOutputHintFunctionAsync.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAsyncTableFunction(ExtractWithOutputHintFunctionAsyncTable.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction(ExtractWithInputHintFunction.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"b", (DataType)DataTypes.BOOLEAN(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE)))), TestSpec.forScalarFunction(TableArgScalarFunction.class).expectErrorMessage("Only scalar arguments are supported at this location. But argument 't' declared the following traits: [ROW_SEMANTIC_TABLE]"), TestSpec.forAggregateFunction(InputDependentAccumulatorFunction.class).expectAccumulator(TypeStrategies.mapping(Map.of(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f", (DataType)DataTypes.BIGINT())})), InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.STRING()))), TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f", (DataType)DataTypes.STRING())}))))).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.STRING())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.STRING()))), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAggregateFunction(AggregateFunctionWithManyAnnotations.class).expectStaticArgument(StaticArgument.scalar((String)"r", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}), (boolean)false)).expectAccumulator(TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))).expectOutput(TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forAggregateFunction(StateHintAggregateFunction.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectState("myAcc", TypeStrategies.explicit((DataType)MyState.TYPE)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forAggregateFunction(StateHintInFunctionHintAggregateFunction.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectState("myAcc", TypeStrategies.explicit((DataType)MyState.TYPE)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forTableFunction(OutputHintTableFunction.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))), TestSpec.forScalarFunction(InvalidMethodScalarFunction.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\njava.lang.String eval(int[])"), TestSpec.forAsyncScalarFunction(InvalidMethodScalarFunctionAsync.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\neval(java.util.concurrent.CompletableFuture, int[])"), TestSpec.forAsyncTableFunction(InvalidMethodTableFunctionAsync.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\neval(java.util.concurrent.CompletableFuture, int[])"), TestSpec.forAsyncTableFunction(InvalidMethodTableFunctionMissingCollection.class).expectErrorMessage("The method 'eval' expects nested generic type CompletableFuture<Collection> for the 0 arg."), TestSpec.forAsyncTableFunction(InvalidMethodTableFunctionWrongGeneric.class).expectErrorMessage("The method 'eval' expects nested generic type CompletableFuture<Collection> for the 0 arg."), TestSpec.forAsyncTableFunction(ConflictingReturnTypesAsyncTable.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\neval(java.util.concurrent.CompletableFuture, int)"), TestSpec.forAggregateFunction(InvalidMethodAggregateFunction.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\naccumulate(java.lang.Integer, int, boolean)\nPattern: (<accumulator> [, <argument>]*)"), TestSpec.forTableFunction(MissingMethodTableFunction.class).expectErrorMessage("Could not find a publicly accessible method named 'eval'."), TestSpec.forScalarFunction(NamedArgumentsScalarFunction.class), TestSpec.forScalarFunction(InputGroupScalarFunction.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction(VarArgInputGroupScalarFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction("Scalar function with implicit overloading order", OrderedScalarFunction.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"l"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forScalarFunction("Scalar function with explicit overloading order by class annotations", OrderedScalarFunction2.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forScalarFunction("Scalar function with explicit overloading order by method annotations", OrderedScalarFunction3.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forTableFunction("A data type hint on the class is used instead of a function output hint", DataTypeHintOnTableFunctionClass.class).expectEmptyStaticArguments().expectOutput(TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}))), TestSpec.forTableFunction("A data type hint on the method is used instead of a function output hint", DataTypeHintOnTableFunctionMethod.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}))), TestSpec.forTableFunction("Invalid data type hint on top of method and class", InvalidDataTypeHintOnTableFunction.class).expectErrorMessage("More than one data type hint found for output of function. Please use a function hint instead."), TestSpec.forScalarFunction("A data type hint on the method is used for enriching (not a function output hint)", DataTypeHintOnScalarFunction.class).expectEmptyStaticArguments().expectOutput(TypeStrategies.explicit((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}).bridgedTo(RowData.class)))), TestSpec.forAsyncScalarFunction("A data type hint on the method is used for enriching (not a function output hint)", DataTypeHintOnScalarFunctionAsync.class).expectEmptyStaticArguments().expectOutput(TypeStrategies.explicit((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}).bridgedTo(RowData.class)))), TestSpec.forAsyncTableFunction("A data type hint on the method is used for enriching (not a function output hint)", DataTypeHintOnTableFunctionAsync.class).expectEmptyStaticArguments().expectOutput(TypeStrategies.explicit((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}).bridgedTo(RowData.class)))), TestSpec.forScalarFunction("Scalar function with arguments hints", ArgumentHintScalarFunction.class).expectStaticArgument(StaticArgument.scalar((String)"f1", (DataType)DataTypes.STRING(), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"f2", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction("Scalar function with arguments hints missing type", ArgumentHintMissingTypeScalarFunction.class).expectErrorMessage("Data type missing for scalar argument at position 0."), TestSpec.forScalarFunction("Scalar function with arguments hints all missing name", ArgumentHintMissingNameScalarFunction.class).expectStaticArgument(StaticArgument.scalar((String)"arg0", (DataType)DataTypes.STRING(), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"arg1", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction("Scalar function with arguments hints all missing partial name", ArgumentHintMissingPartialNameScalarFunction.class).expectErrorMessage("Argument names in function hint must be either fully set or not set at all."), TestSpec.forScalarFunction("Scalar function with arguments hints name conflict", ArgumentHintNameConflictScalarFunction.class).expectErrorMessage("Argument name conflict, there are at least two argument names that are the same."), TestSpec.forScalarFunction("Scalar function with arguments hints on method parameter", ArgumentHintOnParameterScalarFunction.class).expectStaticArgument(StaticArgument.scalar((String)"in1", (DataType)DataTypes.STRING(), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"in2", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forScalarFunction("Scalar function with arguments hints and inputs hints both defined", ArgumentsAndInputsScalarFunction.class).expectErrorMessage("Argument and input hints cannot be declared in the same function hint."), TestSpec.forScalarFunction("Scalar function with argument hint and data type hint declared in the same parameter", ArgumentsHintAndDataTypeHintScalarFunction.class).expectErrorMessage("Argument and data type hints cannot be declared at the same time at position 0."), TestSpec.forScalarFunction("An invalid scalar function that declare FunctionHint for both class and method in the same class.", InvalidFunctionHintOnClassAndMethod.class).expectErrorMessage("Argument and input hints cannot be declared in the same function hint."), TestSpec.forScalarFunction("A valid scalar class that declare FunctionHint for both class and method in the same class.", ValidFunctionHintOnClassAndMethod.class).expectStaticArgument(StaticArgument.scalar((String)"f1", (DataType)DataTypes.STRING(), (boolean)true)).expectStaticArgument(StaticArgument.scalar((String)"f2", (DataType)DataTypes.INT(), (boolean)true)), TestSpec.forScalarFunction("The FunctionHint of the function conflicts with the method.", ScalarFunctionWithFunctionHintConflictMethod.class).expectErrorMessage("Considering all hints, the method should comply with the signature"), TestSpec.forScalarFunction("Scalar function with overloaded functions and arguments hint declared.", ArgumentsHintScalarFunctionWithOverloadedFunction.class), TestSpec.forScalarFunction("Scalar function with argument type not null but optional.", ArgumentHintNotNullTypeWithOptionalsScalarFunction.class).expectErrorMessage("Argument at position 0 is optional but its type doesn't accept null value."), TestSpec.forScalarFunction("Scalar function with arguments hint and variable length args", ArgumentHintVariableLengthScalarFunction.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"f1", "f2"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING()), InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forProcessTableFunction(StatelessProcessTableFunction.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcessTableFunction(StateProcessTableFunction.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectState("s", TypeStrategies.explicit((DataType)MyState.TYPE)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcessTableFunction(NamedStateProcessTableFunction.class).expectStaticArgument(StaticArgument.scalar((String)"myArg", (DataType)DataTypes.INT(), (boolean)false)).expectState("myState", TypeStrategies.explicit((DataType)MyState.TYPE)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcessTableFunction(MultiStateProcessTableFunction.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectState("s1", TypeStrategies.explicit((DataType)MyFirstState.TYPE), Duration.ofDays(2L)).expectState("s2", TypeStrategies.explicit((DataType)MySecondState.TYPE), Duration.ZERO).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcessTableFunction(UntypedTableArgProcessTableFunction.class).expectStaticArgument(StaticArgument.table((String)"t", Row.class, (boolean)false, EnumSet.of(StaticArgumentTrait.ROW_SEMANTIC_TABLE))).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcessTableFunction(TypedTableArgProcessTableFunction.class).expectStaticArgument(StaticArgument.table((String)"t", (DataType)TypedTableArgProcessTableFunction.Customer.TYPE, (boolean)false, EnumSet.of(StaticArgumentTrait.ROW_SEMANTIC_TABLE))).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcessTableFunction(ComplexProcessTableFunction.class).expectStaticArgument(StaticArgument.table((String)"setTable", RowData.class, (boolean)false, EnumSet.of(StaticArgumentTrait.SET_SEMANTIC_TABLE, StaticArgumentTrait.OPTIONAL_PARTITION_BY))).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectStaticArgument(StaticArgument.table((String)"rowTable", Row.class, (boolean)false, EnumSet.of(StaticArgumentTrait.ROW_SEMANTIC_TABLE))).expectStaticArgument(StaticArgument.scalar((String)"s", (DataType)DataTypes.STRING(), (boolean)true)).expectState("s1", TypeStrategies.explicit((DataType)MyFirstState.TYPE)).expectState("other", TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f", (DataType)DataTypes.FLOAT())}))).expectOutput(TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))), TestSpec.forProcessTableFunction(ComplexProcessTableFunctionWithFunctionHint.class).expectStaticArgument(StaticArgument.table((String)"setTable", RowData.class, (boolean)false, EnumSet.of(StaticArgumentTrait.SET_SEMANTIC_TABLE, StaticArgumentTrait.OPTIONAL_PARTITION_BY))).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectStaticArgument(StaticArgument.table((String)"rowTable", Row.class, (boolean)false, EnumSet.of(StaticArgumentTrait.ROW_SEMANTIC_TABLE))).expectStaticArgument(StaticArgument.scalar((String)"s", (DataType)DataTypes.STRING(), (boolean)true)).expectState("s1", TypeStrategies.explicit((DataType)MyFirstState.TYPE)).expectState("other", TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f", (DataType)DataTypes.FLOAT())}))).expectOutput(TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}))), TestSpec.forProcessTableFunction(WrongStateOrderProcessTableFunction.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\neval(org.apache.flink.table.types.extraction.TypeInferenceExtractorTest.MyFirstState, int)\nPattern: (<context>? [, <state>]* [, <argument>]*)"), TestSpec.forProcessTableFunction(MissingStateTypeProcessTableFunction.class).expectErrorMessage("Could not extract a data type from 'class java.lang.Object' in parameter 0 of method 'eval'"), TestSpec.forProcessTableFunction(EnrichedExtractionStateProcessTableFunction.class).expectState("u", TypeStrategies.explicit((DataType)EnrichedExtractionStateProcessTableFunction.User.TYPE)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcessTableFunction(MissingDefaultConstructorStateProcessTableFunction.class).expectErrorMessage("State entries must provide an argument-less constructor so that all fields are mutable."), TestSpec.forProcessTableFunction(NonCompositeStateProcessTableFunction.class).expectErrorMessage("State entries must use a mutable, composite data type. But was: INT"), TestSpec.forProcessTableFunction(WrongTypedTableProcessTableFunction.class).expectErrorMessage("Invalid data type 'INT' for table argument 'i'. Typed table arguments must use a composite type (i.e. row or structured type)."), TestSpec.forProcessTableFunction(WrongArgumentTraitsProcessTableFunction.class).expectErrorMessage("Invalid argument traits for argument 'r'. Trait OPTIONAL_PARTITION_BY requires SET_SEMANTIC_TABLE."), TestSpec.forProcessTableFunction(MixingStaticAndInputGroupProcessTableFunction.class).expectErrorMessage("Process table functions require a non-overloaded, non-vararg, and static signature."), TestSpec.forProcessTableFunction(MultiEvalProcessTableFunction.class).expectErrorMessage("Process table functions require a non-overloaded, non-vararg, and static signature."));
    }

    private static Stream<TestSpec> procedureSpecs() {
        return Stream.of(TestSpec.forProcedure(FullProcedureHint.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"s", (DataType)DataTypes.STRING(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forProcedure(FullProcedureHints.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forProcedure(GlobalOutputProcedureHint.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.STRING()))), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(SplitFullProcedureHints.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forProcedure(ComplexProcedureHint.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"myInt", "myAny"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.ARRAY((DataType)DataTypes.INT())), InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.BOOLEAN())), TestSpec.forProcedure(GlobalInputProcedureHints.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(ZeroArgProcedure.class).expectEmptyStaticArguments().expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(MixedArgProcedure.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"d", (DataType)DataTypes.DOUBLE(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(OverloadedProcedure.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i", "d"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)DataTypes.DOUBLE())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"s"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.BIGINT().notNull()).bridgedTo(Long.TYPE)))), TestSpec.forProcedure(VarArgProcedure.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"i", "more"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))), InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forProcedure(VarArgWithByteProcedure.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"bytes"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.TINYINT().notNull()).bridgedTo(Byte.TYPE)))}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forProcedure(ExtractWithOutputHintProcedure.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure(ExtractWithInputHintProcedure.class).expectStaticArgument(StaticArgument.scalar((String)"i", (DataType)DataTypes.INT(), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"b", (DataType)DataTypes.BOOLEAN(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE)))), TestSpec.forProcedure(NamedArgumentsProcedure.class), TestSpec.forProcedure(InputGroupProcedure.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forProcedure(VarArgInputGroupProcedure.class).expectOutputMapping(InputTypeStrategies.varyingSequence((String[])new String[]{"o"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.ANY}), TypeStrategies.explicit((DataType)DataTypes.STRING())), TestSpec.forProcedure("Procedure with implicit overloading order", OrderedProcedure.class).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"i"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT())}), TypeStrategies.explicit((DataType)DataTypes.INT())).expectOutputMapping(InputTypeStrategies.sequence((String[])new String[]{"l"}, (ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.BIGINT())}), TypeStrategies.explicit((DataType)DataTypes.BIGINT())), TestSpec.forProcedure("Procedure with explicit overloading order by class annotations", OrderedProcedure2.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure("Procedure with explicit overloading order by method annotations", OrderedProcedure3.class).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.BIGINT()))), TypeStrategies.explicit((DataType)DataTypes.BIGINT())).expectOutputMapping(InputTypeStrategies.sequence(List.of("arg0"), List.of(InputTypeStrategies.explicit((DataType)DataTypes.INT()))), TypeStrategies.explicit((DataType)DataTypes.INT())), TestSpec.forProcedure("A data type hint on the method is used for enriching (not a function output hint)", DataTypeHintOnProcedure.class).expectEmptyStaticArguments().expectOutput(TypeStrategies.explicit((DataType)((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())}).bridgedTo(RowData.class)))), TestSpec.forProcedure(InvalidSingleOutputProcedureHint.class).expectErrorMessage("Procedure hints that lead to ambiguous results are not allowed."), TestSpec.forProcedure(InvalidFullOutputProcedureHint.class).expectErrorMessage("Procedure hints with same input definition but different result types are not allowed."), TestSpec.forProcedure(InvalidFullOutputProcedureWithArgNamesHint.class).expectErrorMessage("Procedure hints with same input definition but different result types are not allowed."), TestSpec.forProcedure(IncompleteProcedureHint.class).expectErrorMessage("Data type missing for scalar argument at position 1."), TestSpec.forProcedure(InvalidMethodProcedure.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\njava.lang.String[] call(_, int[])\nPattern: (<context> [, <argument>]*)"), TestSpec.forProcedure(MissingMethodProcedure.class).expectErrorMessage("Could not find a publicly accessible method named 'call'."), TestSpec.forProcedure("Named arguments procedure with argument hint on method", ArgumentHintOnMethodProcedure.class).expectStaticArgument(StaticArgument.scalar((String)"f1", (DataType)DataTypes.STRING(), (boolean)true)).expectStaticArgument(StaticArgument.scalar((String)"f2", (DataType)DataTypes.INT(), (boolean)true)).expectOutput(TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on class", ArgumentHintOnClassProcedure.class).expectStaticArgument(StaticArgument.scalar((String)"f1", (DataType)DataTypes.STRING(), (boolean)true)).expectStaticArgument(StaticArgument.scalar((String)"f2", (DataType)DataTypes.INT(), (boolean)true)).expectOutput(TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on parameter", ArgumentHintOnParameterProcedure.class).expectStaticArgument(StaticArgument.scalar((String)"parameter_f1", (DataType)DataTypes.STRING(), (boolean)true)).expectStaticArgument(StaticArgument.scalar((String)"parameter_f2", (DataType)((DataType)DataTypes.INT().bridgedTo(Integer.TYPE)), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on method and parameter", ArgumentHintOnMethodAndParameterProcedure.class).expectStaticArgument(StaticArgument.scalar((String)"local_f1", (DataType)DataTypes.STRING(), (boolean)true)).expectStaticArgument(StaticArgument.scalar((String)"local_f2", (DataType)DataTypes.INT(), (boolean)true)).expectOutput(TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on class and method", ArgumentHintOnClassAndMethodProcedure.class).expectStaticArgument(StaticArgument.scalar((String)"global_f1", (DataType)DataTypes.STRING(), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"global_f2", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint on class and method and parameter", ArgumentHintOnClassAndMethodAndParameterProcedure.class).expectStaticArgument(StaticArgument.scalar((String)"global_f1", (DataType)DataTypes.STRING(), (boolean)false)).expectStaticArgument(StaticArgument.scalar((String)"global_f2", (DataType)DataTypes.INT(), (boolean)false)).expectOutput(TypeStrategies.explicit((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE)))), TestSpec.forProcedure("Named arguments procedure with argument hint type not null but optional", ArgumentHintNotNullWithOptionalProcedure.class).expectErrorMessage("Argument at position 1 is optional but its type doesn't accept null value."), TestSpec.forProcedure("Named arguments procedure with argument name conflict", ArgumentHintNameConflictProcedure.class).expectErrorMessage("Argument name conflict, there are at least two argument names that are the same."), TestSpec.forProcedure("Named arguments procedure with optional type on primitive type", ArgumentHintOptionalOnPrimitiveParameterConflictProcedure.class).expectErrorMessage("Considering all hints, the method should comply with the signature:\nint[] call(_, java.lang.String, java.lang.Integer)"));
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testStaticArguments(TestSpec testSpec) {
        if (testSpec.expectedStaticArguments != null) {
            Optional staticArguments = testSpec.typeInferenceExtraction.get().getStaticArguments();
            Assertions.assertThat((Optional)staticArguments).isPresent();
            Assertions.assertThat((List)((List)staticArguments.get())).containsExactlyElementsOf(testSpec.expectedStaticArguments);
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testInputTypeStrategy(TestSpec testSpec) {
        if (!testSpec.expectedOutputStrategies.isEmpty()) {
            Assertions.assertThat((Object)testSpec.typeInferenceExtraction.get().getInputTypeStrategy()).isEqualTo(testSpec.expectedOutputStrategies.keySet().stream().reduce((xva$0, xva$1) -> InputTypeStrategies.or((InputTypeStrategy[])new InputTypeStrategy[]{xva$0, xva$1})).orElseThrow(AssertionError::new));
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testStateTypeStrategies(TestSpec testSpec) {
        if (!testSpec.expectedStateStrategies.isEmpty()) {
            Assertions.assertThat((Map)testSpec.typeInferenceExtraction.get().getStateTypeStrategies()).isNotEmpty();
            Assertions.assertThat((Map)testSpec.typeInferenceExtraction.get().getStateTypeStrategies()).isEqualTo(testSpec.expectedStateStrategies);
        } else if (testSpec.expectedErrorMessage == null) {
            Assertions.assertThat((Map)testSpec.typeInferenceExtraction.get().getStateTypeStrategies()).isEmpty();
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testOutputTypeStrategy(TestSpec testSpec) {
        if (!testSpec.expectedOutputStrategies.isEmpty()) {
            if (testSpec.expectedOutputStrategies.size() == 1) {
                Assertions.assertThat((Object)testSpec.typeInferenceExtraction.get().getOutputTypeStrategy()).isEqualTo((Object)testSpec.expectedOutputStrategies.values().iterator().next());
            } else {
                Assertions.assertThat((Object)testSpec.typeInferenceExtraction.get().getOutputTypeStrategy()).isEqualTo((Object)TypeStrategies.mapping(testSpec.expectedOutputStrategies));
            }
        }
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"testData"})
    void testErrorMessage(TestSpec testSpec) {
        if (testSpec.expectedErrorMessage != null) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(testSpec.typeInferenceExtraction::get).isInstanceOf(ValidationException.class)).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)testSpec.expectedErrorMessage)});
        } else {
            testSpec.typeInferenceExtraction.get();
        }
    }

    private static class TableArgScalarFunction
    extends ScalarFunction {
        private TableArgScalarFunction() {
        }

        public int eval(@ArgumentHint(value={ArgumentTrait.ROW_SEMANTIC_TABLE}) Row t) {
            return 0;
        }
    }

    private static class NonCompositeStateProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private NonCompositeStateProcessTableFunction() {
        }

        public int eval(@StateHint Integer i, @ArgumentHint(value={ArgumentTrait.ROW_SEMANTIC_TABLE}) Row t) {
            return 0;
        }
    }

    private static class MissingDefaultConstructorStateProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private MissingDefaultConstructorStateProcessTableFunction() {
        }

        public int eval(@StateHint Score s, @ArgumentHint(value={ArgumentTrait.ROW_SEMANTIC_TABLE}) Row t) {
            return 0;
        }

        public static class Score {
            public final int value;

            public Score(int value) {
                this.value = value;
            }
        }
    }

    private static class MultiEvalProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private MultiEvalProcessTableFunction() {
        }

        public void eval(int i) {
        }

        public void eval(String i) {
        }
    }

    private static class InvalidInputGroupTableArgProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private InvalidInputGroupTableArgProcessTableFunction() {
        }

        public void eval(@ArgumentHint(value={ArgumentTrait.ROW_SEMANTIC_TABLE}, type=@DataTypeHint(inputGroup=InputGroup.ANY)) Row r) {
        }
    }

    private static class MixingStaticAndInputGroupProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private MixingStaticAndInputGroupProcessTableFunction() {
        }

        public void eval(@ArgumentHint(value={ArgumentTrait.ROW_SEMANTIC_TABLE}) Row r, @DataTypeHint(inputGroup=InputGroup.ANY) Object o) {
        }
    }

    private static class WrongArgumentTraitsProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private WrongArgumentTraitsProcessTableFunction() {
        }

        public void eval(@ArgumentHint(value={ArgumentTrait.ROW_SEMANTIC_TABLE, ArgumentTrait.OPTIONAL_PARTITION_BY}) Row r) {
        }
    }

    private static class WrongTypedTableProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private WrongTypedTableProcessTableFunction() {
        }

        public void eval(@ArgumentHint(value={ArgumentTrait.SET_SEMANTIC_TABLE}) Integer i) {
        }
    }

    private static class EnrichedExtractionStateProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private EnrichedExtractionStateProcessTableFunction() {
        }

        public void eval(@StateHint(type=@DataTypeHint(defaultDecimalPrecision=3, defaultDecimalScale=2)) User u) {
        }

        public static class User {
            static final DataType TYPE = DataTypes.STRUCTURED(User.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"score", (DataType)DataTypes.DECIMAL((int)3, (int)2))});
            public BigDecimal score;
        }
    }

    private static class MissingStateTypeProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private MissingStateTypeProcessTableFunction() {
        }

        public void eval(@StateHint Object state) {
        }
    }

    private static class WrongStateOrderProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private WrongStateOrderProcessTableFunction() {
        }

        public void eval(int i, @StateHint MyFirstState state) {
        }
    }

    @FunctionHint(state={@StateHint(name="s1", type=@DataTypeHint(bridgedTo=MyFirstState.class)), @StateHint(name="other", type=@DataTypeHint(value="ROW<f FLOAT>"))}, arguments={@ArgumentHint(name="setTable", value={ArgumentTrait.SET_SEMANTIC_TABLE, ArgumentTrait.OPTIONAL_PARTITION_BY}, type=@DataTypeHint(bridgedTo=RowData.class)), @ArgumentHint(name="i", type=@DataTypeHint(value="INT")), @ArgumentHint(name="rowTable", value={ArgumentTrait.ROW_SEMANTIC_TABLE}), @ArgumentHint(name="s", isOptional=true, type=@DataTypeHint(value="STRING"))}, output=@DataTypeHint(value="ROW<b BOOLEAN>"))
    private static class ComplexProcessTableFunctionWithFunctionHint
    extends ProcessTableFunction<Row> {
        private ComplexProcessTableFunctionWithFunctionHint() {
        }

        public void eval(ProcessTableFunction.Context context, MyFirstState arg0, Row arg1, RowData arg2, Integer arg3, Row arg4, String arg5) {
        }
    }

    @DataTypeHint(value="ROW<b BOOLEAN>")
    private static class ComplexProcessTableFunction
    extends ProcessTableFunction<Row> {
        private ComplexProcessTableFunction() {
        }

        public void eval(ProcessTableFunction.Context context, @StateHint(name="s1") MyFirstState s1, @StateHint(name="other", type=@DataTypeHint(value="ROW<f FLOAT>")) Row s2, @ArgumentHint(value={ArgumentTrait.SET_SEMANTIC_TABLE, ArgumentTrait.OPTIONAL_PARTITION_BY}, name="setTable") RowData t1, @ArgumentHint(name="i") Integer i, @ArgumentHint(value={ArgumentTrait.ROW_SEMANTIC_TABLE}, name="rowTable") Row t2, @ArgumentHint(isOptional=true, name="s") String s) {
        }
    }

    private static class TypedTableArgProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private TypedTableArgProcessTableFunction() {
        }

        public void eval(@ArgumentHint(value={ArgumentTrait.ROW_SEMANTIC_TABLE}) Customer t) {
        }

        public static class Customer {
            static final DataType TYPE = DataTypes.STRUCTURED(Customer.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())});
            public String name;
            public Integer age;
        }
    }

    private static class UntypedTableArgProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private UntypedTableArgProcessTableFunction() {
        }

        public void eval(@ArgumentHint(value={ArgumentTrait.ROW_SEMANTIC_TABLE}) Row t) {
        }
    }

    private static class MultiStateProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private MultiStateProcessTableFunction() {
        }

        public void eval(@StateHint(ttl="2 days") MyFirstState s1, @StateHint(ttl="0") MySecondState s2, Integer i) {
        }
    }

    private static class NamedStateProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private NamedStateProcessTableFunction() {
        }

        public void eval(@StateHint(name="myState") MyState s, @ArgumentHint(name="myArg") Integer i) {
        }
    }

    private static class StateProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private StateProcessTableFunction() {
        }

        public void eval(@StateHint MyState s, Integer i) {
        }
    }

    public static class MySecondState {
        static final DataType TYPE = DataTypes.STRUCTURED(MySecondState.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"i", (DataType)DataTypes.INT())});
        public Integer i;
    }

    public static class MyFirstState {
        static final DataType TYPE = DataTypes.STRUCTURED(MyFirstState.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"d", (DataType)DataTypes.DOUBLE())});
        public Double d;
    }

    public static class MyState {
        static final DataType TYPE = DataTypes.STRUCTURED(MyState.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"d", (DataType)((DataType)((DataType)DataTypes.DOUBLE().notNull()).bridgedTo(Double.TYPE)))});
        public double d;
    }

    private static class StatelessProcessTableFunction
    extends ProcessTableFunction<Integer> {
        private StatelessProcessTableFunction() {
        }

        public void eval(int i) {
        }
    }

    private static class ArgumentHintVariableLengthScalarFunction
    extends ScalarFunction {
        private ArgumentHintVariableLengthScalarFunction() {
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")}, isVarArgs=true)
        public String eval(String f1, Integer ... f2) {
            return "";
        }
    }

    private static class ArgumentHintNotNullTypeWithOptionalsScalarFunction
    extends ScalarFunction {
        private ArgumentHintNotNullTypeWithOptionalsScalarFunction() {
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING NOT NULL"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentsHintScalarFunctionWithOverloadedFunction
    extends ScalarFunction {
        private ArgumentsHintScalarFunctionWithOverloadedFunction() {
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})
        public String eval(String f1, Integer f2) {
            return "";
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="STRING"), name="f2")})
        public String eval(String f1, String f2) {
            return "";
        }
    }

    @FunctionHints(value={@FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")}), @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})})
    private static class ScalarFunctionWithFunctionHintConflictMethod
    extends ScalarFunction {
        private ScalarFunctionWithFunctionHintConflictMethod() {
        }

        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
    private static class ValidFunctionHintOnClassAndMethod
    extends ScalarFunction {
        private ValidFunctionHintOnClassAndMethod() {
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})
    private static class InvalidFunctionHintOnClassAndMethod
    extends ScalarFunction {
        private InvalidFunctionHintOnClassAndMethod() {
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")}, input={@DataTypeHint(value="STRING"), @DataTypeHint(value="INTEGER")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentsHintAndDataTypeHintScalarFunction
    extends ScalarFunction {
        private ArgumentsHintAndDataTypeHintScalarFunction() {
        }

        public String eval(@DataTypeHint(value="STRING") @ArgumentHint(name="f1", type=@DataTypeHint(value="STRING")) String f1, @ArgumentHint(name="f2", type=@DataTypeHint(value="INTEGER")) Integer f2) {
            return "";
        }
    }

    private static class ArgumentsAndInputsScalarFunction
    extends ScalarFunction {
        private ArgumentsAndInputsScalarFunction() {
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")}, input={@DataTypeHint(value="STRING"), @DataTypeHint(value="INTEGER")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintOnParameterScalarFunction
    extends ScalarFunction {
        private ArgumentHintOnParameterScalarFunction() {
        }

        public String eval(@ArgumentHint(type=@DataTypeHint(value="STRING"), name="in1") String f1, @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="in2") Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintNameConflictScalarFunction
    extends ScalarFunction {
        private ArgumentHintNameConflictScalarFunction() {
        }

        @FunctionHint(arguments={@ArgumentHint(name="in1", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="in1", type=@DataTypeHint(value="INTEGER"))})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintMissingPartialNameScalarFunction
    extends ScalarFunction {
        private ArgumentHintMissingPartialNameScalarFunction() {
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="in1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"))})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintMissingNameScalarFunction
    extends ScalarFunction {
        private ArgumentHintMissingNameScalarFunction() {
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING")), @ArgumentHint(type=@DataTypeHint(value="INTEGER"))})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintMissingTypeScalarFunction
    extends ScalarFunction {
        private ArgumentHintMissingTypeScalarFunction() {
        }

        @FunctionHint(arguments={@ArgumentHint(name="f1"), @ArgumentHint(name="f2")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class ArgumentHintScalarFunction
    extends ScalarFunction {
        private ArgumentHintScalarFunction() {
        }

        @FunctionHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2")})
        public String eval(String f1, Integer f2) {
            return "";
        }
    }

    private static class DataTypeHintOnTableFunctionAsync
    extends AsyncTableFunction<String> {
        private DataTypeHintOnTableFunctionAsync() {
        }

        @DataTypeHint(value="ROW<i INT>", bridgedTo=RowData.class)
        public void eval(CompletableFuture<Collection<RowData>> f) {
        }
    }

    private static class DataTypeHintOnScalarFunctionAsync
    extends AsyncScalarFunction {
        private DataTypeHintOnScalarFunctionAsync() {
        }

        public void eval(@DataTypeHint(value="ROW<i INT>") CompletableFuture<RowData> f) {
        }
    }

    private static class InvalidMethodTableFunctionWrongGeneric
    extends AsyncTableFunction<Long> {
        private InvalidMethodTableFunctionWrongGeneric() {
        }

        public void eval(CompletableFuture<Optional<Long>> f, int[] i) {
        }
    }

    private static class InvalidMethodTableFunctionMissingCollection
    extends AsyncTableFunction<Long> {
        private InvalidMethodTableFunctionMissingCollection() {
        }

        public void eval(CompletableFuture<Long> f, int[] i) {
        }
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"))
    private static class InvalidMethodTableFunctionAsync
    extends AsyncTableFunction<Long> {
        private InvalidMethodTableFunctionAsync() {
        }

        public void eval(CompletableFuture<Collection<Long>> f, int[] i) {
        }
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"))
    private static class InvalidMethodScalarFunctionAsync
    extends AsyncScalarFunction {
        private InvalidMethodScalarFunctionAsync() {
        }

        public void eval(CompletableFuture<Long> f, int[] i) {
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class ExtractWithOutputHintFunctionAsyncTable
    extends AsyncTableFunction<Object> {
        private ExtractWithOutputHintFunctionAsyncTable() {
        }

        public void eval(CompletableFuture<Collection<Object>> f, Integer i) {
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class ExtractWithOutputHintFunctionAsync
    extends AsyncScalarFunction {
        private ExtractWithOutputHintFunctionAsync() {
        }

        public void eval(CompletableFuture<Object> f, Integer i) {
        }
    }

    private static class VarArgWithByteFunctionAsyncTable
    extends AsyncTableFunction<String> {
        private VarArgWithByteFunctionAsyncTable() {
        }

        public void eval(CompletableFuture<Collection<String>> f, byte ... bytes) {
        }
    }

    private static class VarArgWithByteFunctionAsync
    extends AsyncScalarFunction {
        private VarArgWithByteFunctionAsync() {
        }

        public void eval(CompletableFuture<String> f, byte ... bytes) {
        }
    }

    private static class VarArgFunctionAsyncTable
    extends AsyncTableFunction<String> {
        private VarArgFunctionAsyncTable() {
        }

        public void eval(CompletableFuture<Collection<String>> f, int i, int ... more) {
        }
    }

    private static class VarArgFunctionAsync
    extends AsyncScalarFunction {
        private VarArgFunctionAsync() {
        }

        public void eval(CompletableFuture<String> f, int i, int ... more) {
        }
    }

    private static class ConflictingReturnTypesAsyncTable
    extends AsyncTableFunction<Integer> {
        private ConflictingReturnTypesAsyncTable() {
        }

        public void eval(CompletableFuture<Collection<Long>> f, int i) {
        }
    }

    private static class OverloadedFunctionAsyncTable
    extends AsyncTableFunction<Integer> {
        private OverloadedFunctionAsyncTable() {
        }

        public void eval(CompletableFuture<Collection<Integer>> f, int i, Double d) {
        }

        public void eval(CompletableFuture<Collection<Integer>> f, String s) {
        }
    }

    private static class OverloadedFunctionAsync
    extends AsyncScalarFunction {
        private OverloadedFunctionAsync() {
        }

        public void eval(CompletableFuture<Integer> f, int i, Double d) {
        }

        public void eval(CompletableFuture<Long> f, String s) {
        }
    }

    private static class MixedArgFunctionAsyncTable
    extends AsyncTableFunction<Integer> {
        private MixedArgFunctionAsyncTable() {
        }

        public void eval(CompletableFuture<Collection<Integer>> f, int i, Double d) {
        }
    }

    private static class MixedArgFunctionAsync
    extends AsyncScalarFunction {
        private MixedArgFunctionAsync() {
        }

        public void eval(CompletableFuture<Integer> f, int i, Double d) {
        }
    }

    private static class ZeroArgFunctionAsyncTable
    extends AsyncTableFunction<Integer> {
        private ZeroArgFunctionAsyncTable() {
        }

        public void eval(CompletableFuture<Collection<Integer>> f) {
        }
    }

    private static class ZeroArgFunctionAsync
    extends AsyncScalarFunction {
        private ZeroArgFunctionAsync() {
        }

        public void eval(CompletableFuture<Integer> f) {
        }
    }

    private static class ArgumentHintOptionalOnPrimitiveParameterConflictProcedure
    implements Procedure {
        private ArgumentHintOptionalOnPrimitiveParameterConflictProcedure() {
        }

        @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
        public int[] call(Object procedureContext, String f1, int f2) {
            return null;
        }
    }

    private static class ArgumentHintNameConflictProcedure
    implements Procedure {
        private ArgumentHintNameConflictProcedure() {
        }

        @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER NOT NULL"), name="f1", isOptional=true)})
        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    private static class ArgumentHintNotNullWithOptionalProcedure
    implements Procedure {
        private ArgumentHintNotNullWithOptionalProcedure() {
        }

        @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER NOT NULL"), name="f2", isOptional=true)})
        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="global_f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="global_f2")})
    private static class ArgumentHintOnClassAndMethodAndParameterProcedure
    implements Procedure {
        private ArgumentHintOnClassAndMethodAndParameterProcedure() {
        }

        @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="local_f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="local_f2", isOptional=true)})
        public int[] call(Object procedureContext, @ArgumentHint(type=@DataTypeHint(value="STRING"), name="parameter_f1", isOptional=false) String f1, Integer f2) {
            return null;
        }
    }

    private static class ArgumentHintOnMethodAndParameterProcedure
    implements Procedure {
        private ArgumentHintOnMethodAndParameterProcedure() {
        }

        @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="local_f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="local_f2", isOptional=true)})
        public int[] call(Object procedureContext, @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="parameter_f1", isOptional=true) String f1, @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="parameter_f2", isOptional=false) Integer f2) {
            return null;
        }
    }

    @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="global_f1"), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="global_f2")})
    private static class ArgumentHintOnClassAndMethodProcedure
    implements Procedure {
        private ArgumentHintOnClassAndMethodProcedure() {
        }

        @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="local_f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="local_f2", isOptional=true)})
        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    private static class ArgumentHintOnParameterProcedure
    implements Procedure {
        private ArgumentHintOnParameterProcedure() {
        }

        public int[] call(Object procedureContext, @ArgumentHint(type=@DataTypeHint(value="STRING"), name="parameter_f1", isOptional=true) String f1, @ArgumentHint(type=@DataTypeHint(value="INT"), name="parameter_f2") int f2) {
            return null;
        }
    }

    @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
    private static class ArgumentHintOnClassProcedure
    implements Procedure {
        private ArgumentHintOnClassProcedure() {
        }

        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    private static class ArgumentHintOnMethodProcedure
    implements Procedure {
        private ArgumentHintOnMethodProcedure() {
        }

        @ProcedureHint(arguments={@ArgumentHint(type=@DataTypeHint(value="STRING"), name="f1", isOptional=true), @ArgumentHint(type=@DataTypeHint(value="INTEGER"), name="f2", isOptional=true)})
        public int[] call(Object procedureContext, String f1, Integer f2) {
            return null;
        }
    }

    private static class MissingMethodProcedure
    implements Procedure {
        private MissingMethodProcedure() {
        }

        public int[] call1(Object procedureContext) {
            return null;
        }
    }

    private static class DataTypeHintOnProcedure
    implements Procedure {
        private DataTypeHintOnProcedure() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public RowData[] call(Object procedureContext) {
            return null;
        }
    }

    private static class OrderedProcedure3
    implements Procedure {
        private OrderedProcedure3() {
        }

        @ProcedureHints(value={@ProcedureHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
        public Number[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    @ProcedureHints(value={@ProcedureHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
    private static class OrderedProcedure2
    implements Procedure {
        private OrderedProcedure2() {
        }

        public Number[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    private static class OrderedProcedure
    implements Procedure {
        private OrderedProcedure() {
        }

        public Long[] call(Object procedureContext, Long l) {
            return null;
        }

        public Integer[] call(Object procedureContext, Integer i) {
            return null;
        }
    }

    private static class VarArgInputGroupProcedure
    implements Procedure {
        private VarArgInputGroupProcedure() {
        }

        public String[] call(Object procedureContext, Object ... o) {
            return null;
        }
    }

    private static class InputGroupProcedure
    implements Procedure {
        private InputGroupProcedure() {
        }

        public String[] call(Object procedureContext, @DataTypeHint(inputGroup=InputGroup.ANY) Object o) {
            return null;
        }
    }

    private static class NamedArgumentsProcedure
    implements Procedure {
        private NamedArgumentsProcedure() {
        }

        public Integer[] call(Object procedureContext, int n) {
            return null;
        }

        public Integer[] call(Object procedureContext, long n) {
            return null;
        }

        public Integer[] call(Object procedureContext, @DataTypeHint(value="DECIMAL(10, 2)") Object n) {
            return null;
        }
    }

    @ProcedureHint(output=@DataTypeHint(value="STRING"))
    private static class InvalidMethodProcedure
    implements Procedure {
        private InvalidMethodProcedure() {
        }

        public Long[] call(Object procedureContext, int[] i) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="BOOLEAN")}, argumentNames={"i", "b"})
    private static class ExtractWithInputHintProcedure
    implements Procedure {
        private ExtractWithInputHintProcedure() {
        }

        public double[] call(Object procedureContext, Object ... o) {
            return new double[]{0.0};
        }
    }

    @ProcedureHint(output=@DataTypeHint(value="INT"))
    private static class ExtractWithOutputHintProcedure
    implements Procedure {
        private ExtractWithOutputHintProcedure() {
        }

        public Object[] call(Object procedureContext, Integer i) {
            return null;
        }
    }

    private static class VarArgWithByteProcedure
    implements Procedure {
        private VarArgWithByteProcedure() {
        }

        public String[] call(Object procedureContext, byte ... bytes) {
            return null;
        }
    }

    private static class VarArgProcedure
    implements Procedure {
        private VarArgProcedure() {
        }

        public String[] call(Object procedureContext, int i, int ... more) {
            return null;
        }
    }

    private static class OverloadedProcedure
    implements Procedure {
        private OverloadedProcedure() {
        }

        public Integer[] call(Object procedureContext, int i, Double d) {
            return null;
        }

        public long[] call(Object procedureContext, String s) {
            return null;
        }
    }

    private static class MixedArgProcedure
    implements Procedure {
        private MixedArgProcedure() {
        }

        public Integer[] call(Object procedureContext, int i, Double d) {
            return null;
        }
    }

    private static class ZeroArgProcedure
    implements Procedure {
        private ZeroArgProcedure() {
        }

        public Integer[] call(Object procedureContext) {
            return null;
        }
    }

    @ProcedureHints(value={@ProcedureHint(input={@DataTypeHint(value="INT")}), @ProcedureHint(input={@DataTypeHint(value="BIGINT")})})
    private static class GlobalInputProcedureHints
    implements Procedure {
        private GlobalInputProcedureHints() {
        }

        @ProcedureHint(output=@DataTypeHint(value="INT"))
        public Integer[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT"), @DataTypeHint}, output=@DataTypeHint(value="BOOLEAN"))
    private static class IncompleteProcedureHint
    implements Procedure {
        private IncompleteProcedureHint() {
        }

        public Boolean[] call(Object procedureContext, Integer i1, Integer i2) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT")})
    private static class InvalidLocalOutputProcedureHint
    implements Procedure {
        private InvalidLocalOutputProcedureHint() {
        }

        @ProcedureHint(output=@DataTypeHint(value="INT"))
        public Integer[] call(Object procedureContext, Integer n) {
            return null;
        }

        @ProcedureHint(output=@DataTypeHint(value="STRING"))
        public Integer[] call(Object procedureContext, String n) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT")}, argumentNames={"a"}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputProcedureWithArgNamesHint
    implements Procedure {
        private InvalidFullOutputProcedureWithArgNamesHint() {
        }

        @ProcedureHint(input={@DataTypeHint(value="INT")}, argumentNames={"b"}, output=@DataTypeHint(value="BIGINT"))
        public Number[] call(Object procedureContext, Integer i) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputProcedureHint
    implements Procedure {
        private InvalidFullOutputProcedureHint() {
        }

        @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="BIGINT"))
        public Number[] call(Object procedureContext, Integer i) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class SplitFullProcedureHints
    implements Procedure {
        private SplitFullProcedureHints() {
        }

        @ProcedureHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))
        public Number[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    @ProcedureHint(output=@DataTypeHint(value="INT"))
    private static class InvalidSingleOutputProcedureHint
    implements Procedure {
        private InvalidSingleOutputProcedureHint() {
        }

        @ProcedureHint(output=@DataTypeHint(value="TINYINT"))
        public Integer call(Object procedureContext, Number n) {
            return null;
        }
    }

    @ProcedureHint(output=@DataTypeHint(value="INT"))
    private static class GlobalOutputProcedureHint
    implements Procedure {
        private GlobalOutputProcedureHint() {
        }

        @ProcedureHint(input={@DataTypeHint(value="INT")})
        public Integer[] call(Object procedureContext, Integer n) {
            return null;
        }

        @ProcedureHint(input={@DataTypeHint(value="STRING")})
        public Integer[] call(Object procedureContext, String n) {
            return null;
        }
    }

    @ProcedureHints(value={@ProcedureHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT")), @ProcedureHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))})
    private static class FullProcedureHints
    implements Procedure {
        private FullProcedureHints() {
        }

        public Number[] call(Object procedureContext, Number n) {
            return null;
        }
    }

    private static class ComplexProcedureHint
    implements Procedure {
        private ComplexProcedureHint() {
        }

        @ProcedureHint(input={@DataTypeHint(value="ARRAY<INT>"), @DataTypeHint(inputGroup=InputGroup.ANY)}, argumentNames={"myInt", "myAny"}, output=@DataTypeHint(value="BOOLEAN"), isVarArgs=true)
        public Boolean[] call(Object procedureContext, Object ... o) {
            return null;
        }
    }

    @ProcedureHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="STRING")}, argumentNames={"i", "s"}, output=@DataTypeHint(value="BOOLEAN"))
    private static class FullProcedureHint
    implements Procedure {
        private FullProcedureHint() {
        }

        public Boolean[] call(Object procedureContext, Integer i, String s) {
            return null;
        }
    }

    private static class DataTypeHintOnScalarFunction
    extends ScalarFunction {
        private DataTypeHintOnScalarFunction() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public RowData eval() {
            return null;
        }
    }

    @DataTypeHint(value="ROW<i BOOLEAN>")
    private static class InvalidDataTypeHintOnTableFunction
    extends TableFunction<Row> {
        private InvalidDataTypeHintOnTableFunction() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public void eval(Integer i) {
        }
    }

    private static class DataTypeHintOnTableFunctionMethod
    extends TableFunction<Row> {
        private DataTypeHintOnTableFunctionMethod() {
        }

        @DataTypeHint(value="ROW<i INT>")
        public void eval(Integer i) {
        }
    }

    @DataTypeHint(value="ROW<i INT>")
    private static class DataTypeHintOnTableFunctionClass
    extends TableFunction<Row> {
        private DataTypeHintOnTableFunctionClass() {
        }

        public void eval() {
        }
    }

    private static class OrderedScalarFunction3
    extends ScalarFunction {
        private OrderedScalarFunction3() {
        }

        @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
        public Number eval(Number n) {
            return n;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT")), @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))})
    private static class OrderedScalarFunction2
    extends ScalarFunction {
        private OrderedScalarFunction2() {
        }

        public Number eval(Number n) {
            return n;
        }
    }

    private static class OrderedScalarFunction
    extends ScalarFunction {
        private OrderedScalarFunction() {
        }

        public Long eval(Long l) {
            return l;
        }

        public Integer eval(Integer i) {
            return i;
        }
    }

    private static class VarArgInputGroupScalarFunction
    extends ScalarFunction {
        private VarArgInputGroupScalarFunction() {
        }

        public String eval(Object ... o) {
            return Arrays.toString(o);
        }
    }

    private static class InputGroupScalarFunction
    extends ScalarFunction {
        private InputGroupScalarFunction() {
        }

        public String eval(@DataTypeHint(inputGroup=InputGroup.ANY) Object o) {
            return o.toString();
        }
    }

    private static class NamedArgumentsScalarFunction
    extends ScalarFunction {
        private NamedArgumentsScalarFunction() {
        }

        public Integer eval(int n) {
            return null;
        }

        public Integer eval(long n) {
            return null;
        }

        public Integer eval(@DataTypeHint(value="DECIMAL(10, 2)") Object n) {
            return null;
        }
    }

    private static class MissingMethodTableFunction
    extends TableFunction<String> {
        private MissingMethodTableFunction() {
        }
    }

    @FunctionHint(accumulator=@DataTypeHint(value="INT"))
    private static class InvalidMethodAggregateFunction
    extends AggregateFunction<String, Boolean> {
        private InvalidMethodAggregateFunction() {
        }

        public void accumulate(Boolean acc, int a, boolean b) {
        }

        public String getValue(Boolean accumulator) {
            return null;
        }

        public Boolean createAccumulator() {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"))
    private static class InvalidMethodScalarFunction
    extends ScalarFunction {
        private InvalidMethodScalarFunction() {
        }

        public Long eval(int[] i) {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="ROW<i INT, b BOOLEAN>"))
    private static class OutputHintTableFunction
    extends TableFunction<Row> {
        private OutputHintTableFunction() {
        }

        public void eval(int i) {
        }
    }

    @FunctionHint(state={@StateHint(name="myAcc", type=@DataTypeHint(bridgedTo=MyState.class))}, arguments={@ArgumentHint(name="i", type=@DataTypeHint(value="INT"))})
    private static class StateHintInFunctionHintAggregateFunction
    extends AggregateFunction<Integer, Object> {
        private StateHintInFunctionHintAggregateFunction() {
        }

        public void accumulate(Object acc, Integer i) {
        }

        public Integer getValue(Object accumulator) {
            return null;
        }

        public Object createAccumulator() {
            return new Object();
        }
    }

    private static class StateHintAggregateFunction
    extends AggregateFunction<Integer, MyState> {
        private StateHintAggregateFunction() {
        }

        public void accumulate(@StateHint(name="myAcc") MyState acc, @ArgumentHint(name="i") Integer i) {
        }

        public Integer getValue(MyState accumulator) {
            return null;
        }

        public MyState createAccumulator() {
            return new MyState();
        }
    }

    @FunctionHint(output=@DataTypeHint(value="STRING"))
    private static class AggregateFunctionWithManyAnnotations
    extends AggregateFunction<String, Row> {
        private AggregateFunctionWithManyAnnotations() {
        }

        @FunctionHint(accumulator=@DataTypeHint(value="ROW<b BOOLEAN>"))
        public void accumulate(Row accumulator, @DataTypeHint(value="ROW<i INT, b BOOLEAN>") Row r) {
        }

        public String getValue(Row accumulator) {
            return null;
        }

        public Row createAccumulator() {
            return null;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="BIGINT")}, accumulator=@DataTypeHint(value="ROW<f BIGINT>")), @FunctionHint(input={@DataTypeHint(value="STRING")}, accumulator=@DataTypeHint(value="ROW<f STRING>"))})
    private static class InputDependentAccumulatorFunction
    extends AggregateFunction<String, Row> {
        private InputDependentAccumulatorFunction() {
        }

        public void accumulate(Row accumulator, Object o) {
        }

        public String getValue(Row accumulator) {
            return null;
        }

        public Row createAccumulator() {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="BOOLEAN")}, argumentNames={"i", "b"})
    private static class ExtractWithInputHintFunction
    extends ScalarFunction {
        private ExtractWithInputHintFunction() {
        }

        public double eval(Object ... o) {
            return 0.0;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class ExtractWithOutputHintFunction
    extends ScalarFunction {
        private ExtractWithOutputHintFunction() {
        }

        public Object eval(Integer i) {
            return null;
        }
    }

    private static class VarArgWithByteFunction
    extends ScalarFunction {
        private VarArgWithByteFunction() {
        }

        public String eval(byte ... bytes) {
            return null;
        }
    }

    private static class VarArgFunction
    extends ScalarFunction {
        private VarArgFunction() {
        }

        public String eval(int i, int ... more) {
            return null;
        }
    }

    private static class OverloadedFunction
    extends ScalarFunction {
        private OverloadedFunction() {
        }

        public Integer eval(int i, Double d) {
            return null;
        }

        public long eval(String s) {
            return 0L;
        }
    }

    private static class MixedArgFunction
    extends ScalarFunction {
        private MixedArgFunction() {
        }

        public Integer eval(int i, Double d) {
            return null;
        }
    }

    private static class ZeroArgFunction
    extends ScalarFunction {
        private ZeroArgFunction() {
        }

        public Integer eval() {
            return null;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="INT")}), @FunctionHint(input={@DataTypeHint(value="BIGINT")})})
    private static class GlobalInputFunctionHints
    extends ScalarFunction {
        private GlobalInputFunctionHints() {
        }

        @FunctionHint(output=@DataTypeHint(value="INT"))
        public Integer eval(Number n) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT"), @DataTypeHint}, output=@DataTypeHint(value="BOOLEAN"))
    private static class IncompleteFunctionHint
    extends ScalarFunction {
        private IncompleteFunctionHint() {
        }

        public Boolean eval(Integer i1, Integer i2) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")})
    private static class InvalidLocalOutputFunctionHint
    extends ScalarFunction {
        private InvalidLocalOutputFunctionHint() {
        }

        @FunctionHint(output=@DataTypeHint(value="INT"))
        public Integer eval(Integer n) {
            return null;
        }

        @FunctionHint(output=@DataTypeHint(value="STRING"))
        public Integer eval(String n) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")}, argumentNames={"a"}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputFunctionWithArgNamesHint
    extends ScalarFunction {
        private InvalidFullOutputFunctionWithArgNamesHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="INT")}, argumentNames={"b"}, output=@DataTypeHint(value="BIGINT"))
        public Number eval(Integer i) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class InvalidFullOutputFunctionHint
    extends ScalarFunction {
        private InvalidFullOutputFunctionHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="BIGINT"))
        public Number eval(Integer i) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT"))
    private static class SplitFullFunctionHints
    extends ScalarFunction {
        private SplitFullFunctionHints() {
        }

        @FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))
        public Number eval(Number n) {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class InvalidSingleOutputFunctionHint
    extends ScalarFunction {
        private InvalidSingleOutputFunctionHint() {
        }

        @FunctionHint(output=@DataTypeHint(value="TINYINT"))
        public Integer eval(Number n) {
            return null;
        }
    }

    @FunctionHint(output=@DataTypeHint(value="INT"))
    private static class GlobalOutputFunctionHint
    extends ScalarFunction {
        private GlobalOutputFunctionHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="INT")})
        public Integer eval(Integer n) {
            return null;
        }

        @FunctionHint(input={@DataTypeHint(value="STRING")})
        public Integer eval(String n) {
            return null;
        }
    }

    @FunctionHints(value={@FunctionHint(input={@DataTypeHint(value="INT")}, output=@DataTypeHint(value="INT")), @FunctionHint(input={@DataTypeHint(value="BIGINT")}, output=@DataTypeHint(value="BIGINT"))})
    private static class FullFunctionHints
    extends ScalarFunction {
        private FullFunctionHints() {
        }

        public Number eval(Number n) {
            return null;
        }
    }

    private static class ComplexFunctionHint
    extends ScalarFunction {
        private ComplexFunctionHint() {
        }

        @FunctionHint(input={@DataTypeHint(value="ARRAY<INT>"), @DataTypeHint(inputGroup=InputGroup.ANY)}, argumentNames={"myInt", "myAny"}, output=@DataTypeHint(value="BOOLEAN"), isVarArgs=true)
        public Boolean eval(Object ... o) {
            return null;
        }
    }

    @FunctionHint(input={@DataTypeHint(value="INT"), @DataTypeHint(value="STRING")}, argumentNames={"i", "s"}, output=@DataTypeHint(value="BOOLEAN"))
    private static class FullFunctionHint
    extends ScalarFunction {
        private FullFunctionHint() {
        }

        public Boolean eval(Integer i, String s) {
            return null;
        }
    }

    static class TestSpec {
        private final String description;
        final Supplier<TypeInference> typeInferenceExtraction;
        @Nullable
        List<StaticArgument> expectedStaticArguments;
        LinkedHashMap<String, StateTypeStrategy> expectedStateStrategies;
        Map<InputTypeStrategy, TypeStrategy> expectedOutputStrategies;
        @Nullable
        String expectedErrorMessage;

        private TestSpec(String description, Supplier<TypeInference> typeInferenceExtraction) {
            this.description = description;
            this.typeInferenceExtraction = typeInferenceExtraction;
            this.expectedStateStrategies = new LinkedHashMap();
            this.expectedOutputStrategies = new LinkedHashMap<InputTypeStrategy, TypeStrategy>();
        }

        static TestSpec forScalarFunction(Class<? extends ScalarFunction> function) {
            return TestSpec.forScalarFunction(null, function);
        }

        static TestSpec forScalarFunction(String description, Class<? extends ScalarFunction> function) {
            return new TestSpec(description == null ? function.getSimpleName() : description, () -> TypeInferenceExtractor.forScalarFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forAsyncScalarFunction(Class<? extends AsyncScalarFunction> function) {
            return TestSpec.forAsyncScalarFunction(null, function);
        }

        static TestSpec forAsyncScalarFunction(String description, Class<? extends AsyncScalarFunction> function) {
            return new TestSpec(description == null ? function.getSimpleName() : description, () -> TypeInferenceExtractor.forAsyncScalarFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forAsyncTableFunction(Class<? extends AsyncTableFunction<?>> function) {
            return TestSpec.forAsyncTableFunction(null, function);
        }

        static TestSpec forAsyncTableFunction(String description, Class<? extends AsyncTableFunction<?>> function) {
            return new TestSpec(description == null ? function.getSimpleName() : description, () -> TypeInferenceExtractor.forAsyncTableFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forAggregateFunction(Class<? extends AggregateFunction<?, ?>> function) {
            return new TestSpec(function.getSimpleName(), () -> TypeInferenceExtractor.forAggregateFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forTableFunction(Class<? extends TableFunction<?>> function) {
            return TestSpec.forTableFunction(null, function);
        }

        static TestSpec forTableFunction(String description, Class<? extends TableFunction<?>> function) {
            return new TestSpec(description == null ? function.getSimpleName() : description, () -> TypeInferenceExtractor.forTableFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forTableAggregateFunction(Class<? extends TableAggregateFunction<?, ?>> function) {
            return new TestSpec(function.getSimpleName(), () -> TypeInferenceExtractor.forTableAggregateFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forProcessTableFunction(Class<? extends ProcessTableFunction<?>> function) {
            return new TestSpec(function.getSimpleName(), () -> TypeInferenceExtractor.forProcessTableFunction((DataTypeFactory)new DataTypeFactoryMock(), (Class)function));
        }

        static TestSpec forProcedure(Class<? extends Procedure> procedure) {
            return TestSpec.forProcedure(null, procedure);
        }

        static TestSpec forProcedure(@Nullable String description, Class<? extends Procedure> procedure) {
            return new TestSpec(description == null ? procedure.getSimpleName() : description, () -> TypeInferenceExtractor.forProcedure((DataTypeFactory)new DataTypeFactoryMock(), (Class)procedure));
        }

        TestSpec expectEmptyStaticArguments() {
            this.expectedStaticArguments = new ArrayList<StaticArgument>();
            return this;
        }

        TestSpec expectStaticArgument(StaticArgument argument) {
            if (this.expectedStaticArguments == null) {
                this.expectedStaticArguments = new ArrayList<StaticArgument>();
            }
            this.expectedStaticArguments.add(argument);
            return this;
        }

        TestSpec expectAccumulator(TypeStrategy typeStrategy) {
            this.expectState("acc", typeStrategy);
            return this;
        }

        TestSpec expectState(String name, TypeStrategy typeStrategy) {
            return this.expectState(name, typeStrategy, null);
        }

        TestSpec expectState(String name, TypeStrategy typeStrategy, @Nullable Duration ttl) {
            this.expectedStateStrategies.put(name, StateTypeStrategy.of((TypeStrategy)typeStrategy, (Duration)ttl));
            return this;
        }

        TestSpec expectOutputMapping(InputTypeStrategy validator, TypeStrategy outputStrategy) {
            this.expectedOutputStrategies.put(validator, outputStrategy);
            return this;
        }

        TestSpec expectOutput(TypeStrategy outputStrategy) {
            this.expectedOutputStrategies.put((InputTypeStrategy)InputTypeStrategies.WILDCARD, outputStrategy);
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        public String toString() {
            return this.description;
        }
    }
}

