/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.catalog.AbstractCatalogStore;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.factories.CatalogStoreFactory;

public class TestCatalogStoreFactory
implements CatalogStoreFactory {
    public static final String IDENTIFIER = "test-catalog-store";
    public static final Map<String, CatalogDescriptor> SHARED_DESCRIPTORS = new HashMap<String, CatalogDescriptor>();

    public CatalogStore createCatalogStore() {
        return new TestCatalogStore(SHARED_DESCRIPTORS);
    }

    public void open(CatalogStoreFactory.Context context) throws CatalogException {
    }

    public void close() throws CatalogException {
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public static class TestCatalogStore
    extends AbstractCatalogStore {
        private final Map<String, CatalogDescriptor> sharedDescriptors;

        public TestCatalogStore(Map<String, CatalogDescriptor> sharedDescriptors) {
            this.sharedDescriptors = sharedDescriptors;
        }

        public void storeCatalog(String catalogName, CatalogDescriptor catalog) throws CatalogException {
            this.sharedDescriptors.put(catalogName, catalog);
        }

        public void removeCatalog(String catalogName, boolean ignoreIfNotExists) throws CatalogException {
            this.sharedDescriptors.remove(catalogName);
        }

        public Optional<CatalogDescriptor> getCatalog(String catalogName) {
            return Optional.ofNullable(this.sharedDescriptors.get(catalogName));
        }

        public Set<String> listCatalogs() {
            return this.sharedDescriptors.keySet();
        }

        public boolean contains(String catalogName) {
            return this.sharedDescriptors.containsKey(catalogName);
        }
    }
}

