/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.SqlLikeUtils;
import org.apache.flink.table.operations.utils.LikeType;

@Internal
public class ShowLikeOperator {
    private final LikeType likeType;
    private final String likePattern;

    private ShowLikeOperator(LikeType likeType, String likePattern) {
        this.likeType = likeType;
        this.likePattern = likePattern;
    }

    public static ShowLikeOperator of(LikeType likeType, String likePattern) {
        return likeType == null ? null : new ShowLikeOperator(likeType, likePattern);
    }

    public static ShowLikeOperator of(boolean withLike, boolean isNotLike, String likePattern) {
        return ShowLikeOperator.of(withLike, false, isNotLike, likePattern);
    }

    public static ShowLikeOperator of(boolean withLike, boolean isILike, boolean isNotLike, String likePattern) {
        if (!withLike) {
            return null;
        }
        LikeType likeType = LikeType.of(isILike, isNotLike);
        return new ShowLikeOperator(likeType, likePattern);
    }

    public static boolean likeFilter(String row, @Nullable ShowLikeOperator operator) {
        if (operator == null) {
            return true;
        }
        boolean notLike = operator.likeType.isNot();
        boolean isILike = operator.likeType.isILike();
        boolean likeMatch = isILike ? SqlLikeUtils.ilike(row, operator.likePattern, "\\") : SqlLikeUtils.like(row, operator.likePattern, "\\");
        return notLike != likeMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowLikeOperator likeOp = (ShowLikeOperator)o;
        return this.likeType == likeOp.likeType && Objects.equals(this.likePattern, likeOp.likePattern);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.likeType, this.likePattern});
    }

    public String toString() {
        return this.asSummaryString();
    }

    public String asSummaryString() {
        return this.likeType.asSummaryString() + " '" + this.likePattern + "'";
    }
}

