/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;

@Internal
public class CreateDatabaseOperation
implements CreateOperation {
    private final String catalogName;
    private final String databaseName;
    private final CatalogDatabase catalogDatabase;
    private final boolean ignoreIfExists;

    public CreateDatabaseOperation(String catalogName, String databaseName, CatalogDatabase catalogDatabase, boolean ignoreIfExists) {
        this.catalogName = catalogName;
        this.databaseName = databaseName;
        this.catalogDatabase = catalogDatabase;
        this.ignoreIfExists = ignoreIfExists;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public CatalogDatabase getCatalogDatabase() {
        return this.catalogDatabase;
    }

    public boolean isIgnoreIfExists() {
        return this.ignoreIfExists;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogDatabase", this.catalogDatabase.getProperties());
        params.put("catalogName", this.catalogName);
        params.put("databaseName", this.databaseName);
        params.put("ignoreIfExists", this.ignoreIfExists);
        return OperationUtils.formatWithChildren("CREATE DATABASE", params, Collections.emptyList(), Operation::asSummaryString);
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getCatalogManager().createDatabase(this.catalogName, this.databaseName, this.catalogDatabase, this.ignoreIfExists);
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (DatabaseAlreadyExistException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
    }
}

