/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogChange;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterOperation;
import org.apache.flink.util.Preconditions;

@Internal
public class AlterCatalogOptionsOperation
implements AlterOperation {
    private final String catalogName;
    private final Map<String, String> properties;

    public AlterCatalogOptionsOperation(String catalogName, Map<String, String> properties) {
        this.catalogName = (String)Preconditions.checkNotNull((Object)catalogName);
        this.properties = Collections.unmodifiableMap((Map)Preconditions.checkNotNull(properties));
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER CATALOG %s\n%s", this.catalogName, this.properties.entrySet().stream().map(entry -> String.format("  SET '%s' = '%s'", entry.getKey(), entry.getValue())).collect(Collectors.joining(",\n")));
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        try {
            ctx.getCatalogManager().alterCatalog(this.catalogName, (CatalogChange)new CatalogChange.CatalogConfigurationChange(conf -> conf.addAll(Configuration.fromMap(this.properties))));
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (CatalogException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
    }
}

