/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.operations.AbstractShowOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.utils.ShowLikeOperator;

@Internal
public class ShowDatabasesOperation
extends AbstractShowOperation {
    public ShowDatabasesOperation(@Nullable String catalogName, @Nullable String preposition, @Nullable ShowLikeOperator likeOp) {
        super(catalogName, preposition, likeOp);
    }

    public ShowDatabasesOperation(@Nullable String catalogName, @Nullable ShowLikeOperator likeOp) {
        this(catalogName, null, likeOp);
    }

    public ShowDatabasesOperation(@Nullable String catalogName) {
        this(catalogName, null, null);
    }

    @Override
    protected Collection<String> retrieveDataForTableResult(ExecutableOperation.Context ctx) {
        CatalogManager catalogManager = ctx.getCatalogManager();
        String qualifiedCatalogName = catalogManager.qualifyCatalog(this.catalogName);
        return catalogManager.getCatalogOrThrowException(qualifiedCatalogName).listDatabases();
    }

    @Override
    protected String getOperationName() {
        return "SHOW DATABASES";
    }

    @Override
    protected String getColumnName() {
        return "database name";
    }
}

