/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class PartitionQueryOperation
implements QueryOperation {
    private final List<ResolvedExpression> partitionExpressions;
    private final QueryOperation child;

    public PartitionQueryOperation(List<ResolvedExpression> partitionExpressions, QueryOperation child) {
        this.partitionExpressions = partitionExpressions;
        this.child = child;
    }

    public int[] getPartitionKeys() {
        return this.partitionExpressions.stream().map(FieldReferenceExpression.class::cast).map(FieldReferenceExpression::getFieldIndex).mapToInt(Integer::intValue).toArray();
    }

    @Override
    public String asSerializableString(SqlFactory sqlFactory) {
        return String.format("(%s\n) PARTITION BY (%s)", OperationUtils.indent(this.child.asSerializableString(sqlFactory)), this.partitionExpressions.stream().map(expr -> expr.asSerializableString(sqlFactory)).collect(Collectors.joining(", ")));
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("partition", this.partitionExpressions);
        return OperationUtils.formatWithChildren("Partition", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.child.getResolvedSchema();
    }

    @Override
    public List<QueryOperation> getChildren() {
        return List.of(this.child);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

