/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.test.program;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.test.program.TableTestStep;
import org.apache.flink.table.test.program.TestStep;
import org.apache.flink.types.Row;

public final class SourceTestStep
extends TableTestStep {
    public final List<Row> dataBeforeRestore;
    public final List<Row> dataAfterRestore;

    SourceTestStep(String name, List<String> schemaComponents, @Nullable TableDistribution distribution, List<String> partitionKeys, Map<String, String> options, List<Row> dataBeforeRestore, List<Row> dataAfterRestore) {
        super(name, schemaComponents, distribution, partitionKeys, options);
        this.dataBeforeRestore = dataBeforeRestore;
        this.dataAfterRestore = dataAfterRestore;
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    @Override
    public TestStep.TestKind getKind() {
        return this.dataBeforeRestore.isEmpty() ? TestStep.TestKind.SOURCE_WITHOUT_DATA : (this.dataAfterRestore.isEmpty() ? TestStep.TestKind.SOURCE_WITH_DATA : TestStep.TestKind.SOURCE_WITH_RESTORE_DATA);
    }

    public static final class Builder
    extends TableTestStep.AbstractBuilder<Builder> {
        private final List<Row> dataBeforeRestore = new ArrayList<Row>();
        private final List<Row> dataAfterRestore = new ArrayList<Row>();

        private Builder(String name) {
            super(name);
        }

        public Builder producedValues(Row ... data) {
            return this.producedBeforeRestore(data);
        }

        public Builder producedBeforeRestore(Row ... data) {
            this.dataBeforeRestore.addAll(Arrays.asList(data));
            return this;
        }

        public Builder producedAfterRestore(Row ... data) {
            this.dataAfterRestore.addAll(Arrays.asList(data));
            return this;
        }

        public SourceTestStep build() {
            return new SourceTestStep(this.name, this.schemaComponents, this.distribution, this.partitionKeys, this.options, this.dataBeforeRestore, this.dataAfterRestore);
        }
    }
}

