/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.module;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.module.CoreModule;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleEntry;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.utils.ModuleMock;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ModuleManagerTest {
    private ModuleManager manager;

    ModuleManagerTest() {
    }

    @BeforeEach
    public void before() {
        this.manager = new ModuleManager();
    }

    @Test
    void testLoadModuleTwice() {
        Assertions.assertThat((List)this.manager.getUsedModules()).isEqualTo(Collections.singletonList("core"));
        Assertions.assertThat((Object)((Module)this.manager.getLoadedModules().get("core"))).isSameAs((Object)CoreModule.INSTANCE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.manager.loadModule("core", (Module)CoreModule.INSTANCE)).isInstanceOf(ValidationException.class)).hasMessage("A module with name 'core' already exists");
    }

    @Test
    void testLoadModuleWithoutUnusedModulesExist() {
        ModuleMock x = new ModuleMock("x");
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule(x.getType(), (Module)x);
        this.manager.loadModule(y.getType(), (Module)y);
        this.manager.loadModule(z.getType(), (Module)z);
        HashMap<String, Object> expectedLoadedModules = new HashMap<String, Object>();
        expectedLoadedModules.put("core", CoreModule.INSTANCE);
        expectedLoadedModules.put("x", x);
        expectedLoadedModules.put("y", y);
        expectedLoadedModules.put("z", z);
        Assertions.assertThat((List)this.manager.getUsedModules()).containsSequence((Object[])new String[]{"core", "x", "y", "z"});
        Assertions.assertThat((Map)this.manager.getLoadedModules()).isEqualTo(expectedLoadedModules);
    }

    @Test
    void testLoadModuleWithUnusedModulesExist() {
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule(y.getType(), (Module)y);
        this.manager.loadModule(z.getType(), (Module)z);
        HashMap<String, Object> expectedLoadedModules = new HashMap<String, Object>();
        expectedLoadedModules.put("core", CoreModule.INSTANCE);
        expectedLoadedModules.put("y", y);
        expectedLoadedModules.put("z", z);
        Assertions.assertThat((List)this.manager.getUsedModules()).containsSequence((Object[])new String[]{"core", "y", "z"});
        Assertions.assertThat((Map)this.manager.getLoadedModules()).isEqualTo(expectedLoadedModules);
        this.manager.useModules(new String[]{"core"});
        ModuleMock x = new ModuleMock("x");
        this.manager.loadModule(x.getType(), (Module)x);
        expectedLoadedModules.put("x", x);
        Assertions.assertThat((List)this.manager.getUsedModules()).containsSequence((Object[])new String[]{"core", "x"});
        Assertions.assertThat((Map)this.manager.getLoadedModules()).isEqualTo(expectedLoadedModules);
    }

    @Test
    void testUnloadModuleTwice() {
        Assertions.assertThat((List)this.manager.getUsedModules()).containsSequence((Object[])new String[]{"core"});
        this.manager.unloadModule("core");
        Assertions.assertThat((List)this.manager.getUsedModules()).isEmpty();
        Assertions.assertThat((Map)this.manager.getLoadedModules()).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.manager.unloadModule("core")).isInstanceOf(ValidationException.class)).hasMessage("No module with name 'core' exists");
    }

    @Test
    void testUseUnloadedModules() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.manager.useModules(new String[]{"core", "x"})).isInstanceOf(ValidationException.class)).hasMessage("No module with name 'x' exists");
    }

    @Test
    void testUseModulesWithDuplicateModuleName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.manager.useModules(new String[]{"core", "core"})).isInstanceOf(ValidationException.class)).hasMessage("Module 'core' appears more than once");
    }

    @Test
    void testUseModules() {
        ModuleMock x = new ModuleMock("x");
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule(x.getType(), (Module)x);
        this.manager.loadModule(y.getType(), (Module)y);
        this.manager.loadModule(z.getType(), (Module)z);
        Assertions.assertThat((List)this.manager.getUsedModules()).containsSequence((Object[])new String[]{"core", "x", "y", "z"});
        this.manager.useModules(new String[]{"z", "core"});
        Assertions.assertThat((List)this.manager.getUsedModules()).containsSequence((Object[])new String[]{"z", "core"});
        HashMap<String, Object> expectedLoadedModules = new HashMap<String, Object>();
        expectedLoadedModules.put("core", CoreModule.INSTANCE);
        expectedLoadedModules.put("x", x);
        expectedLoadedModules.put("y", y);
        expectedLoadedModules.put("z", z);
        Assertions.assertThat((Map)this.manager.getLoadedModules()).isEqualTo(expectedLoadedModules);
    }

    @Test
    void testListModules() {
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule("y", (Module)y);
        this.manager.loadModule("z", (Module)z);
        this.manager.useModules(new String[]{"z", "y"});
        Assertions.assertThat((List)this.manager.listModules()).containsSequence((Object[])new String[]{"z", "y"});
    }

    @Test
    void testListFullModules() {
        ModuleMock x = new ModuleMock("x");
        ModuleMock y = new ModuleMock("y");
        ModuleMock z = new ModuleMock("z");
        this.manager.loadModule("y", (Module)y);
        this.manager.loadModule("x", (Module)x);
        this.manager.loadModule("z", (Module)z);
        this.manager.useModules(new String[]{"z", "y"});
        Assertions.assertThat((List)this.manager.listFullModules()).isEqualTo(ModuleManagerTest.getExpectedModuleEntries(2, "z", "y", "core", "x"));
    }

    @Test
    void testListFunctions() {
        ModuleMock x = new ModuleMock("x");
        this.manager.loadModule(x.getType(), (Module)x);
        Assertions.assertThat((Collection)this.manager.listFunctions()).contains((Object[])new String[]{"dummy"});
        Assertions.assertThat((Collection)this.manager.listFunctions()).doesNotContain((Object[])new String[]{"internal"});
        this.manager.useModules(new String[]{"core"});
        Assertions.assertThat((Collection)this.manager.listFunctions()).doesNotContain((Object[])new String[]{"dummy"});
    }

    @Test
    void testGetFunctionDefinition() {
        ModuleMock x = new ModuleMock("x");
        this.manager.loadModule(x.getType(), (Module)x);
        Assertions.assertThat((Optional)this.manager.getFunctionDefinition("dummy")).isPresent();
        Assertions.assertThat((Optional)this.manager.getFunctionDefinition("internal")).isPresent();
        this.manager.useModules(new String[]{"core"});
        Assertions.assertThat((Optional)this.manager.getFunctionDefinition("dummy")).isEmpty();
    }

    private static List<ModuleEntry> getExpectedModuleEntries(int index, String ... names) {
        return IntStream.range(0, names.length).mapToObj(i -> new ModuleEntry(names[i], i < index)).collect(Collectors.toList());
    }
}

