/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaTranslator;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeFactoryMock;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

class SchemaTranslatorTest {
    SchemaTranslatorTest() {
    }

    @Test
    void testInputFromRow() {
        TypeInformation inputTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT, Types.BOOLEAN}), Types.ENUM(DayOfWeek.class)});
        SchemaTranslator.ConsumingResult result = SchemaTranslator.createConsumingResult((DataTypeFactory)SchemaTranslatorTest.dataTypeFactoryWithRawType(DayOfWeek.class), (TypeInformation)inputTypeInfo, null);
        Assertions.assertThat((Object)result.getPhysicalDataType()).isEqualTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})), DataTypes.FIELD((String)"f1", (DataType)DataTypeFactoryMock.dummyRaw(DayOfWeek.class))}).notNull());
        Assertions.assertThat((boolean)result.isTopLevelRecord()).isTrue();
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BOOLEAN())})).column("f1", (AbstractDataType)DataTypeFactoryMock.dummyRaw(DayOfWeek.class)).build());
        Assertions.assertThat((List)result.getProjections()).isNull();
    }

    @Test
    void testOutputToRowDataType() {
        ResolvedSchema inputSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)DataTypes.INT()), Column.physical((String)"a", (DataType)DataTypes.BOOLEAN()), Column.physical((String)"B", (DataType)DataTypes.DOUBLE())});
        DataType physicalDataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"b", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"c", (DataType)DataTypes.INT())});
        SchemaTranslator.ProducingResult result = SchemaTranslator.createProducingResult((DataTypeFactory)SchemaTranslatorTest.dataTypeFactory(), (ResolvedSchema)inputSchema, (AbstractDataType)physicalDataType);
        Assertions.assertThat((Optional)result.getProjections()).hasValue(Arrays.asList("a", "B", "c"));
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("a", (AbstractDataType)DataTypes.BOOLEAN()).column("b", (AbstractDataType)DataTypes.DOUBLE()).column("c", (AbstractDataType)DataTypes.INT()).build());
        Assertions.assertThat((Optional)result.getPhysicalDataType()).hasValue((Object)physicalDataType);
    }

    @Test
    void testInputFromAtomic() {
        TypeInformation inputTypeInfo = Types.GENERIC(Row.class);
        SchemaTranslator.ConsumingResult result = SchemaTranslator.createConsumingResult((DataTypeFactory)SchemaTranslatorTest.dataTypeFactoryWithRawType(Row.class), (TypeInformation)inputTypeInfo, null);
        Assertions.assertThat((Object)result.getPhysicalDataType()).isEqualTo((Object)DataTypeFactoryMock.dummyRaw(Row.class));
        Assertions.assertThat((boolean)result.isTopLevelRecord()).isFalse();
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypeFactoryMock.dummyRaw(Row.class)).build());
        Assertions.assertThat((List)result.getProjections()).isNull();
    }

    @Test
    void testOutputToAtomicDataType() {
        ResolvedSchema inputSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"a", (DataType)DataTypes.INT())});
        SchemaTranslator.ProducingResult result = SchemaTranslator.createProducingResult((DataTypeFactory)SchemaTranslatorTest.dataTypeFactory(), (ResolvedSchema)inputSchema, (AbstractDataType)DataTypes.INT());
        Assertions.assertThat((Optional)result.getProjections()).isEmpty();
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).build());
        Assertions.assertThat((Optional)result.getPhysicalDataType()).hasValue((Object)DataTypes.INT());
    }

    @Test
    void testInputFromRowWithNonPhysicalDeclaredSchema() {
        TypeInformation inputTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT, Types.LONG});
        SchemaTranslator.ConsumingResult result = SchemaTranslator.createConsumingResult((DataTypeFactory)SchemaTranslatorTest.dataTypeFactory(), (TypeInformation)inputTypeInfo, (Schema)Schema.newBuilder().columnByExpression("computed", "f1 + 42").columnByExpression("computed2", "f1 - 1").primaryKeyNamed("pk", new String[]{"f0"}).build());
        Assertions.assertThat((Object)result.getPhysicalDataType()).isEqualTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT())}).notNull());
        Assertions.assertThat((boolean)result.isTopLevelRecord()).isTrue();
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("f0", DataTypes.INT().notNull()).column("f1", (AbstractDataType)DataTypes.BIGINT()).columnByExpression("computed", "f1 + 42").columnByExpression("computed2", "f1 - 1").primaryKeyNamed("pk", new String[]{"f0"}).build());
        Assertions.assertThat((List)result.getProjections()).isNull();
    }

    @Test
    void testInputFromRowWithPhysicalDeclaredSchema() {
        TypeInformation inputTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT, Types.LONG, Types.GENERIC(BigDecimal.class), Types.BOOLEAN});
        SchemaTranslator.ConsumingResult result = SchemaTranslator.createConsumingResult((DataTypeFactory)SchemaTranslatorTest.dataTypeFactoryWithRawType(BigDecimal.class), (TypeInformation)inputTypeInfo, (Schema)Schema.newBuilder().primaryKeyNamed("pk", new String[]{"f0"}).column("f1", (AbstractDataType)DataTypes.BIGINT()).column("f0", (AbstractDataType)DataTypes.INT()).columnByExpression("computed", "f1 + 42").column("f2", (AbstractDataType)DataTypes.DECIMAL((int)10, (int)2)).columnByExpression("computed2", "f1 - 1").build());
        Assertions.assertThat((Object)result.getPhysicalDataType()).isEqualTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.DECIMAL((int)10, (int)2)), DataTypes.FIELD((String)"f3", (DataType)DataTypes.BOOLEAN())}).notNull());
        Assertions.assertThat((boolean)result.isTopLevelRecord()).isTrue();
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.INT()).column("f1", (AbstractDataType)DataTypes.BIGINT()).column("f2", (AbstractDataType)DataTypes.DECIMAL((int)10, (int)2)).column("f3", (AbstractDataType)DataTypes.BOOLEAN()).columnByExpression("computed", "f1 + 42").columnByExpression("computed2", "f1 - 1").primaryKeyNamed("pk", new String[]{"f0"}).build());
        Assertions.assertThat((List)result.getProjections()).isEqualTo(Arrays.asList("f1", "f0", "computed", "f2", "computed2"));
    }

    @Test
    void testInputFromAtomicWithPhysicalDeclaredSchema() {
        TypeInformation inputTypeInfo = Types.GENERIC(Row.class);
        SchemaTranslator.ConsumingResult result = SchemaTranslator.createConsumingResult((DataTypeFactory)SchemaTranslatorTest.dataTypeFactoryWithRawType(Row.class), (TypeInformation)inputTypeInfo, (Schema)Schema.newBuilder().columnByExpression("f0_0", "f0.f0_0").column("f0", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0_0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f0_1", (DataType)DataTypes.BOOLEAN())})).columnByExpression("f0_1", "f0.f0_1").build());
        Assertions.assertThat((Object)result.getPhysicalDataType()).isEqualTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0_0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f0_1", (DataType)DataTypes.BOOLEAN())}));
        Assertions.assertThat((boolean)result.isTopLevelRecord()).isFalse();
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0_0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f0_1", (DataType)DataTypes.BOOLEAN())})).columnByExpression("f0_0", "f0.f0_0").columnByExpression("f0_1", "f0.f0_1").build());
        Assertions.assertThat((List)result.getProjections()).isEqualTo(Arrays.asList("f0_0", "f0", "f0_1"));
    }

    @Test
    void testInvalidDeclaredSchemaColumn() {
        TypeInformation inputTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT, Types.LONG});
        Assertions.assertThatThrownBy(() -> SchemaTranslator.createConsumingResult((DataTypeFactory)SchemaTranslatorTest.dataTypeFactory(), (TypeInformation)inputTypeInfo, (Schema)Schema.newBuilder().column("INVALID", (AbstractDataType)DataTypes.BIGINT()).build())).satisfies(new ThrowingConsumer[]{FlinkAssertions.anyCauseMatches(ValidationException.class, (String)"Unable to find a field named 'INVALID' in the physical data type")});
    }

    @Test
    void testOutputToNoSchema() {
        ResolvedSchema tableSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.BIGINT()), Column.metadata((String)"rowtime", (DataType)DataTypes.TIMESTAMP_LTZ((int)3), null, (boolean)false), Column.physical((String)"name", (DataType)DataTypes.STRING())});
        SchemaTranslator.ProducingResult result = SchemaTranslator.createProducingResult((ResolvedSchema)tableSchema, null);
        Assertions.assertThat((Optional)result.getProjections()).isEmpty();
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("id", (AbstractDataType)DataTypes.BIGINT()).column("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).column("name", (AbstractDataType)DataTypes.STRING()).build());
        Assertions.assertThat((Optional)result.getPhysicalDataType()).isEmpty();
    }

    @Test
    void testOutputToEmptySchema() {
        ResolvedSchema tableSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.BIGINT()), Column.metadata((String)"rowtime", (DataType)DataTypes.TIMESTAMP_LTZ((int)3), null, (boolean)false), Column.physical((String)"name", (DataType)DataTypes.STRING())});
        SchemaTranslator.ProducingResult result = SchemaTranslator.createProducingResult((ResolvedSchema)tableSchema, (Schema)Schema.derived());
        Assertions.assertThat((Optional)result.getProjections()).isEmpty();
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("id", (AbstractDataType)DataTypes.BIGINT()).column("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).column("name", (AbstractDataType)DataTypes.STRING()).build());
        Assertions.assertThat((Optional)result.getPhysicalDataType()).isEmpty();
    }

    @Test
    void testOutputToPartialSchema() {
        ResolvedSchema tableSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)((DataType)DataTypes.BIGINT().notNull())), Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.metadata((String)"rowtime", (DataType)DataTypes.TIMESTAMP_LTZ((int)3), null, (boolean)false)});
        SchemaTranslator.ProducingResult result = SchemaTranslator.createProducingResult((ResolvedSchema)tableSchema, (Schema)Schema.newBuilder().columnByExpression("computed", "f1 + 42").columnByMetadata("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).primaryKey(new String[]{"id"}).build());
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("id", DataTypes.BIGINT().notNull()).column("name", (AbstractDataType)DataTypes.STRING()).columnByExpression("computed", "f1 + 42").columnByMetadata("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).primaryKey(new String[]{"id"}).build());
    }

    @Test
    void testOutputToDeclaredSchema() {
        ResolvedSchema tableSchema = ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.BIGINT()), Column.physical((String)"rowtime", (DataType)DataTypes.TIMESTAMP_LTZ((int)3)), Column.physical((String)"name", (DataType)DataTypes.STRING())});
        SchemaTranslator.ProducingResult result = SchemaTranslator.createProducingResult((ResolvedSchema)tableSchema, (Schema)Schema.newBuilder().column("id", (AbstractDataType)DataTypes.BIGINT()).columnByMetadata("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).column("name", DataTypes.STRING().bridgedTo(StringData.class)).build());
        Assertions.assertThat((Object)result.getSchema()).isEqualTo((Object)Schema.newBuilder().column("id", (AbstractDataType)DataTypes.BIGINT()).columnByMetadata("rowtime", (AbstractDataType)DataTypes.TIMESTAMP_LTZ((int)3)).column("name", DataTypes.STRING().bridgedTo(StringData.class)).build());
    }

    private static DataTypeFactory dataTypeFactoryWithRawType(Class<?> rawType) {
        DataTypeFactoryMock dataTypeFactory = new DataTypeFactoryMock();
        dataTypeFactory.dataType = Optional.of(DataTypeFactoryMock.dummyRaw(rawType));
        return dataTypeFactory;
    }

    private static DataTypeFactory dataTypeFactory() {
        return new DataTypeFactoryMock();
    }
}

