/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.File;
import java.util.HashMap;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.FileCatalogStore;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileCatalogStoreFactoryTest {
    FileCatalogStoreFactoryTest() {
    }

    @Test
    void testFileCatalogStoreFactoryDiscovery(@TempDir File tempFolder) {
        String factoryIdentifier = "file";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("path", tempFolder.getAbsolutePath());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        FactoryUtil.DefaultCatalogStoreContext discoveryContext = new FactoryUtil.DefaultCatalogStoreContext(options, null, classLoader);
        CatalogStoreFactory factory = (CatalogStoreFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, CatalogStoreFactory.class, (String)factoryIdentifier);
        factory.open((CatalogStoreFactory.Context)discoveryContext);
        CatalogStore catalogStore = factory.createCatalogStore();
        AssertionsForClassTypes.assertThat((boolean)(catalogStore instanceof FileCatalogStore)).isTrue();
        factory.close();
    }
}

