/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterViewOperation;

@Internal
public class AlterViewRenameOperation
extends AlterViewOperation {
    private final ObjectIdentifier newViewIdentifier;

    public AlterViewRenameOperation(ObjectIdentifier viewIdentifier, ObjectIdentifier newViewIdentifier) {
        super(viewIdentifier);
        this.newViewIdentifier = newViewIdentifier;
    }

    public ObjectIdentifier getNewViewIdentifier() {
        return this.newViewIdentifier;
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER VIEW %s RENAME TO %s", this.viewIdentifier.asSummaryString(), this.newViewIdentifier.asSummaryString());
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        Catalog catalog = ctx.getCatalogManager().getCatalogOrThrowException(this.getViewIdentifier().getCatalogName());
        try {
            catalog.renameTable(this.getViewIdentifier().toObjectPath(), this.getNewViewIdentifier().getObjectName(), false);
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (TableAlreadyExistException | TableNotExistException e) {
            throw new ValidationException(String.format("Could not execute %s", this.asSummaryString()), e);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not execute %s", this.asSummaryString()), (Throwable)e);
        }
    }
}

