/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.operations.AbstractShowOperation;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.utils.ShowLikeOperator;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class ShowColumnsOperation
extends AbstractShowOperation {
    private final ObjectIdentifier tableIdentifier;

    public ShowColumnsOperation(ObjectIdentifier tableIdentifier, @Nullable String preposition, @Nullable ShowLikeOperator likeOp) {
        super(tableIdentifier.getCatalogName(), preposition, likeOp);
        this.tableIdentifier = tableIdentifier;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        Optional<ContextResolvedTable> result = ctx.getCatalogManager().getTable(this.tableIdentifier);
        if (!result.isPresent()) {
            throw new ValidationException(String.format("Tables or views with the identifier '%s' doesn't exist.", this.tableIdentifier.asSummaryString()));
        }
        ResolvedSchema schema = result.get().getResolvedSchema();
        Object[][] rows = this.generateTableColumnsRows(schema);
        if (this.likeOp != null) {
            rows = (Object[][])Arrays.stream(rows).filter(row -> ShowLikeOperator.likeFilter(row[0].toString(), this.likeOp)).toArray(x$0 -> new Object[x$0][]);
        }
        boolean nonComments = this.isSchemaNonColumnComments(schema);
        return TableResultUtils.buildTableResult(this.generateTableColumnsNames(nonComments), this.generateTableColumnsDataTypes(nonComments), rows);
    }

    private Object[][] generateTableColumnsRows(ResolvedSchema schema) {
        Map<String, String> fieldToWatermark = schema.getWatermarkSpecs().stream().collect(Collectors.toMap(WatermarkSpec::getRowtimeAttribute, spec -> spec.getWatermarkExpression().asSummaryString()));
        HashMap fieldToPrimaryKey = new HashMap();
        schema.getPrimaryKey().ifPresent(p -> {
            List columns = p.getColumns();
            columns.forEach(c -> fieldToPrimaryKey.put(c, String.format("PRI(%s)", String.join((CharSequence)", ", columns))));
        });
        boolean nonComments = this.isSchemaNonColumnComments(schema);
        return (Object[][])schema.getColumns().stream().map(c -> {
            LogicalType logicalType = c.getDataType().getLogicalType();
            ArrayList<Serializable> result = new ArrayList<Serializable>(Arrays.asList(c.getName(), logicalType.copy(true).asSummaryString(), logicalType.isNullable(), fieldToPrimaryKey.getOrDefault(c.getName(), null), c.explainExtras().orElse(null), fieldToWatermark.getOrDefault(c.getName(), null)));
            if (!nonComments) {
                result.add(c.getComment().orElse(null));
            }
            return result.toArray();
        }).toArray(x$0 -> new Object[x$0][]);
    }

    private boolean isSchemaNonColumnComments(ResolvedSchema schema) {
        return schema.getColumns().stream().map(Column::getComment).noneMatch(Optional::isPresent);
    }

    private String[] generateTableColumnsNames(boolean nonComments) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList("name", "type", "null", "key", "extras", "watermark"));
        if (!nonComments) {
            result.add("comment");
        }
        return result.toArray(new String[0]);
    }

    private DataType[] generateTableColumnsDataTypes(boolean nonComments) {
        ArrayList<DataType> result = new ArrayList<DataType>(Arrays.asList(DataTypes.STRING(), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()));
        if (!nonComments) {
            result.add(DataTypes.STRING());
        }
        return result.toArray(new DataType[0]);
    }

    @Override
    protected String getOperationName() {
        return "SHOW COLUMNS";
    }

    @Override
    protected String getColumnName() {
        return null;
    }

    @Override
    protected Collection<String> retrieveDataForTableResult(ExecutableOperation.Context ctx) {
        return Collections.emptyList();
    }
}

